/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view.undo;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.EntityUpdate;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.LinkUpdate;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.undo.Command;
import com.paterva.maltego.graph.undo.IndexedCommand;
import com.paterva.maltego.graph.undo.UndoRedoBatches;
import com.paterva.maltego.graph.undo.UndoRedoCommandMerger;
import com.paterva.maltego.ui.graph.transactions.GraphOperation;
import com.paterva.maltego.ui.graph.transactions.GraphPositionAndPathHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.util.SimilarStrings;
import java.awt.Point;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LayoutCommandMerger
implements UndoRedoCommandMerger {
    private static final Logger LOG = Logger.getLogger(LayoutCommandMerger.class.getName());
    private static final int MAX_LAYOUTS_TO_COMBINE = 5;
    private static final Point ORIGIN_POINT = new Point(0, 0);
    private static final List<Point> STRAIGHT_PATH = Arrays.asList(ORIGIN_POINT, ORIGIN_POINT);
    private long _lastMergeTime = 0L;
    private int _combinableLayouts = 0;

    public boolean merge(Deque<IndexedCommand> undoStack, Command command, Integer index) {
        String view;
        LOG.log(Level.FINE, "Merge command start: {0} (index={1})", new Object[]{command, index});
        boolean merged = false;
        LayoutInfoPair layoutInfoPair = this.getLayoutInfoToMerge(command, index);
        String string = view = layoutInfoPair != null ? this.getView(layoutInfoPair) : null;
        if (layoutInfoPair != null && view != null) {
            if (LOG.isLoggable(Level.FINE)) {
                String lip = layoutInfoPair.toString();
                LOG.log(Level.FINE, "Layout info: {0}", lip);
            }
            int combinableLayouts = this.getCombinableLayouts();
            ArrayDeque<IndexedCommand> backupUndoStack = new ArrayDeque<IndexedCommand>(undoStack);
            undoStack.clear();
            boolean addRemainingCommands = false;
            int cmdNum = 0;
            int startMergeIndex = 0;
            for (IndexedCommand indexedCommand : backupUndoStack) {
                Integer cmdIndex = indexedCommand.getIndex();
                if (cmdIndex != null && cmdIndex > index) {
                    startMergeIndex = cmdNum + 1;
                }
                ++cmdNum;
            }
            LOG.log(Level.FINE, "Start merge index: {0}", startMergeIndex);
            cmdNum = 0;
            int placeHoldersFound = 0;
            for (IndexedCommand indexedCommand : backupUndoStack) {
                Command cmd = indexedCommand.getCommand();
                if (!addRemainingCommands && cmdNum >= startMergeIndex) {
                    boolean isPlaceholder;
                    LOG.log(Level.FINE, "Trying to merge with: {0} {1}", new Object[]{cmdNum, cmd});
                    if (cmdNum == startMergeIndex) {
                        LOG.fine("Adding merge placeholder");
                        undoStack.add(new IndexedCommand((Command)new MergePlaceHolder(view)));
                    }
                    if (isPlaceholder = this.isPlaceholder(cmd, view)) {
                        LOG.log(Level.FINE, "Placeholders found: {0}", ++placeHoldersFound);
                    }
                    if (!isPlaceholder && !this.isTransactionCommand(cmd) || this.isNonLayoutUpdates(cmd)) {
                        LOG.fine("Do nothing, add command and continue merging");
                    } else if (combinableLayouts > 0 && this.isLayoutMergeCandidate(view, cmd, layoutInfoPair)) {
                        LOG.fine("Merge layouts and stop");
                        this.mergeLayouts(view, cmd, layoutInfoPair);
                        addRemainingCommands = true;
                    } else if (placeHoldersFound > combinableLayouts || !isPlaceholder && !this.isMergeCandidate(cmd)) {
                        LOG.fine("Update command with the remaining layout info");
                        this.updateLayoutCommand(command, layoutInfoPair);
                        undoStack.add(new IndexedCommand(command));
                        addRemainingCommands = true;
                    } else if (!isPlaceholder) {
                        LOG.fine("Merge layouts");
                        this.merge(view, cmd, layoutInfoPair);
                        if (this.isEmpty(layoutInfoPair)) {
                            LOG.fine("All layout info merged");
                            addRemainingCommands = true;
                        } else if (this.isPinBatch((UndoRedoBatches)cmd)) {
                            LOG.fine("Update command with the remaining layout info (2)");
                            this.updateLayoutCommand(command, layoutInfoPair);
                            undoStack.add(new IndexedCommand(command));
                            addRemainingCommands = true;
                        }
                    }
                }
                undoStack.add(indexedCommand);
                ++cmdNum;
            }
            merged = true;
            this.layoutMerged();
        }
        LOG.log(Level.FINE, "Merge command end: {0} ({1})", new Object[]{command, merged ? "merged" : "not merged"});
        return merged;
    }

    private void merge(String view, Command cmd, LayoutInfoPair layoutInfoPair) {
        UndoRedoBatches batches = (UndoRedoBatches)cmd;
        if (this.isSpecificOperationBatch(batches, GraphOperation.Add)) {
            GraphTransactionBatch doBatch = batches.getDoBatch();
            List transactions = doBatch.getTransactions();
            ArrayList<GraphTransaction> mergedTransactions = new ArrayList<GraphTransaction>(transactions.size());
            for (GraphTransaction t : transactions) {
                if (this.isNeedingLayout(t)) {
                    LOG.log(Level.FINE, "Transaction before: {0}", t);
                    t = this.createMergedTransaction(view, t, layoutInfoPair.After);
                    LOG.log(Level.FINE, "Transaction after: {0}", t);
                }
                mergedTransactions.add(t);
            }
            GraphTransactionBatch mergedBatch = new GraphTransactionBatch(doBatch.getDescription(), doBatch.isSignificant(), new GraphTransaction[0]);
            mergedBatch.addAll(mergedTransactions);
            batches.setDoBatch(mergedBatch);
        } else if (this.isPinBatch(batches)) {
            GraphTransactionBatch doBatch = batches.getDoBatch();
            List doTransactions = doBatch.getTransactions();
            ArrayList<GraphTransaction> mergedDoTransactions = new ArrayList<GraphTransaction>(doTransactions.size());
            for (GraphTransaction t : doTransactions) {
                if (this.isNeedingLayout(t)) {
                    LOG.log(Level.FINE, "Transaction before: {0}", t);
                    t = this.createMergedTransaction(view, t, layoutInfoPair.After);
                    LOG.log(Level.FINE, "Transaction after: {0}", t);
                }
                mergedDoTransactions.add(t);
            }
            GraphTransactionBatch mergedDoBatch = new GraphTransactionBatch(doBatch.getDescription(), doBatch.isSignificant(), new GraphTransaction[0]);
            mergedDoBatch.addAll(mergedDoTransactions);
            batches.setDoBatch(mergedDoBatch);
            GraphTransactionBatch undoBatch = batches.getUndoBatch();
            List undoTransactions = undoBatch.getTransactions();
            ArrayList<GraphTransaction> mergedUndoTransactions = new ArrayList<GraphTransaction>(undoTransactions.size());
            for (GraphTransaction t : undoTransactions) {
                if (this.isNeedingLayout(t)) {
                    LOG.log(Level.FINE, "Transaction before: {0}", t);
                    t = this.createMergedTransaction(view, t, layoutInfoPair.Before);
                    LOG.log(Level.FINE, "Transaction after: {0}", t);
                }
                mergedUndoTransactions.add(t);
            }
            GraphTransactionBatch mergedUndoBatch = new GraphTransactionBatch(undoBatch.getDescription(), undoBatch.isSignificant(), new GraphTransaction[0]);
            mergedUndoBatch.addAll(mergedUndoTransactions);
            batches.setUndoBatch(mergedUndoBatch);
        }
        this.cleanup(view, layoutInfoPair);
    }

    private boolean isSpecificOperationBatch(UndoRedoBatches batches, GraphOperation operation) {
        List transactions = batches.getDoBatch().getTransactions();
        for (GraphTransaction transaction : transactions) {
            if (!operation.equals((Object)transaction.getOperation())) continue;
            return true;
        }
        return false;
    }

    private boolean isPinBatch(UndoRedoBatches batches) {
        List transactions = batches.getDoBatch().getTransactions();
        for (GraphTransaction transaction : transactions) {
            Map pinned;
            if (!GraphOperation.Update.equals((Object)transaction.getOperation()) || (pinned = transaction.getPinned()) == null || pinned.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private GraphTransaction createMergedTransaction(String view, GraphTransaction t, LayoutInfo layoutInfo) {
        HashSet<EntityID> entityIDs = new HashSet<EntityID>(t.getEntityIDs());
        if (t.getPinned() != null) {
            entityIDs.addAll(t.getPinned().keySet());
        }
        Set linkIDs = t.getLinkIDs();
        Map linkEntities = GraphTransactionHelper.getLinkEntities((GraphTransaction)t);
        Map tCenters = GraphPositionAndPathHelper.getCenters((GraphTransaction)t);
        Map tPaths = GraphPositionAndPathHelper.getPaths((GraphTransaction)t);
        this.mergeCenters(view, entityIDs, tCenters, layoutInfo.Centers.get(view));
        this.mergePaths(view, linkIDs, tPaths, layoutInfo.Paths.get(view));
        return GraphTransactions.create((GraphOperation)t.getOperation(), this.getEntities(t), this.getLinks(t), (Map)tCenters, (Map)tPaths, (Map)linkEntities, (Map)t.getPinned(), (boolean)t.needsLayout());
    }

    private List<MaltegoEntity> getEntities(GraphTransaction transaction) {
        Set entityIDs = transaction.getEntityIDs();
        ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>(entityIDs.size());
        for (EntityID entityID : entityIDs) {
            entities.add(transaction.getEntity(entityID));
        }
        return entities;
    }

    private List<MaltegoLink> getLinks(GraphTransaction transaction) {
        Set linkIDs = transaction.getLinkIDs();
        ArrayList<MaltegoLink> links = new ArrayList<MaltegoLink>(linkIDs.size());
        for (LinkID linkID : linkIDs) {
            links.add(transaction.getLink(linkID));
        }
        return links;
    }

    private void mergeLayouts(String view, Command cmd, LayoutInfoPair layoutInfoPair) {
        if (cmd instanceof UndoRedoBatches) {
            UndoRedoBatches batches = (UndoRedoBatches)cmd;
            GraphTransactionBatch doBatch = batches.getDoBatch();
            List doTransactions = doBatch.getTransactions();
            GraphTransaction doTransaction = (GraphTransaction)doTransactions.get(0);
            doTransaction = this.mergeLayouts(view, doTransaction, layoutInfoPair.After, true);
            batches.setDoBatch(new GraphTransactionBatch(doBatch.getDescription(), true, new GraphTransaction[]{doTransaction}));
            GraphTransactionBatch undoBatch = batches.getUndoBatch();
            List undoTransactions = undoBatch.getTransactions();
            GraphTransaction undoTransaction = (GraphTransaction)undoTransactions.get(0);
            undoTransaction = this.mergeLayouts(view, undoTransaction, layoutInfoPair.Before, false);
            batches.setUndoBatch(new GraphTransactionBatch(undoBatch.getDescription(), true, new GraphTransaction[]{undoTransaction}));
        }
    }

    private GraphTransaction mergeLayouts(String view, GraphTransaction t, LayoutInfo layout, boolean replace) {
        Map<LinkID, List<Point>> paths;
        Map<EntityID, Point> centers;
        HashSet<MaltegoEntity> entities = new HashSet<MaltegoEntity>(this.getEntities(t));
        Map tCenterss = GraphPositionAndPathHelper.getCenters((GraphTransaction)t);
        HashMap<EntityID, Point> tCenters = (HashMap<EntityID, Point>)tCenterss.get(view);
        if (tCenters == null) {
            tCenters = new HashMap<EntityID, Point>();
            tCenterss.put(view, tCenters);
        }
        if ((centers = layout.Centers.get(view)) != null) {
            for (Map.Entry<EntityID, Point> entry : centers.entrySet()) {
                EntityID id = entry.getKey();
                boolean exist = tCenters.containsKey(id);
                if (!replace && exist) continue;
                tCenters.put(id, entry.getValue());
                if (exist) continue;
                entities.add((MaltegoEntity)new EntityUpdate(id));
            }
        }
        HashSet<MaltegoLink> links = new HashSet<MaltegoLink>(this.getLinks(t));
        Map tPathss = GraphPositionAndPathHelper.getPaths((GraphTransaction)t);
        HashMap<LinkID, List<Point>> tPaths = (HashMap<LinkID, List<Point>>)tPathss.get(view);
        if (tPaths == null) {
            tPaths = new HashMap<LinkID, List<Point>>();
            tPathss.put(view, tPaths);
        }
        if ((paths = layout.Paths.get(view)) != null) {
            for (Map.Entry<LinkID, List<Point>> entry : paths.entrySet()) {
                LinkID id = entry.getKey();
                boolean exist = tPaths.containsKey(id);
                if (!replace && exist) continue;
                tPaths.put(id, entry.getValue());
                if (exist) continue;
                links.add((MaltegoLink)new LinkUpdate(id));
            }
        }
        return GraphTransactions.create((GraphOperation)GraphOperation.Update, entities, links, (Map)tCenterss, (Map)tPathss, (Map)Collections.EMPTY_MAP, (Map)t.getPinned(), (boolean)false);
    }

    private LayoutInfoPair getLayoutInfoToMerge(Command command, Integer index) {
        LayoutInfo layoutBefore;
        UndoRedoBatches batches;
        LayoutInfo layoutAfter;
        LayoutInfoPair layoutPair = null;
        if (!command.isSignificant() && index != null && command instanceof UndoRedoBatches && (layoutAfter = this.getLayoutInfo((batches = (UndoRedoBatches)command).getDoBatch())) != null && (layoutBefore = this.getLayoutInfo(batches.getUndoBatch())) != null) {
            layoutPair = new LayoutInfoPair();
            layoutPair.Before = layoutBefore;
            layoutPair.After = layoutAfter;
        }
        return layoutPair;
    }

    private LayoutInfo getLayoutInfo(GraphTransactionBatch batch) {
        GraphTransaction transaction;
        LayoutInfo layoutInfo = null;
        List transactions = batch.getTransactions();
        if (transactions.size() == 1 && GraphOperation.Update.equals((Object)(transaction = (GraphTransaction)transactions.get(0)).getOperation()) && transaction.getViews().size() > 0) {
            Map centers = GraphPositionAndPathHelper.getCenters((GraphTransaction)transaction);
            Map paths = GraphPositionAndPathHelper.getPaths((GraphTransaction)transaction);
            if (!centers.isEmpty() || !paths.isEmpty()) {
                layoutInfo = new LayoutInfo();
                layoutInfo.Centers = centers;
                layoutInfo.Paths = paths;
            }
        }
        return layoutInfo;
    }

    private boolean isNonLayoutUpdates(Command cmd) {
        if (cmd instanceof UndoRedoBatches) {
            UndoRedoBatches batches = (UndoRedoBatches)cmd;
            GraphTransactionBatch doBatch = batches.getDoBatch();
            List doTransactions = doBatch.getTransactions();
            for (GraphTransaction t : doTransactions) {
                if (this.isNonLayoutUpdateTransaction(t)) continue;
                return false;
            }
            GraphTransactionBatch undoBatch = batches.getUndoBatch();
            List undoTransactions = undoBatch.getTransactions();
            for (GraphTransaction t : undoTransactions) {
                if (this.isNonLayoutUpdateTransaction(t)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isNonLayoutUpdateTransaction(GraphTransaction t) {
        return !GraphOperation.Add.equals((Object)t.getOperation()) && !GraphOperation.Delete.equals((Object)t.getOperation()) && (t.getPinned() == null || t.getPinned().isEmpty()) && t.getViews().isEmpty();
    }

    private boolean isPlaceholder(Command cmd, String view) {
        if (cmd instanceof MergePlaceHolder) {
            MergePlaceHolder mergePlaceHolder = (MergePlaceHolder)cmd;
            return view.toLowerCase().equals(mergePlaceHolder.getView().toLowerCase());
        }
        return false;
    }

    private boolean isTransactionCommand(Command cmd) {
        return cmd instanceof UndoRedoBatches;
    }

    private boolean isLayoutMergeCandidate(String view, Command cmd, LayoutInfoPair layoutInfoPair) {
        if (cmd instanceof UndoRedoBatches) {
            UndoRedoBatches batches = (UndoRedoBatches)cmd;
            GraphTransactionBatch doBatch = batches.getDoBatch();
            List doTransactions = doBatch.getTransactions();
            GraphTransactionBatch undoBatch = batches.getUndoBatch();
            List undoTransactions = undoBatch.getTransactions();
            if (doTransactions.size() == 1 && undoTransactions.size() == 1) {
                GraphTransaction doTransaction = (GraphTransaction)doTransactions.get(0);
                GraphTransaction undoTransaction = (GraphTransaction)undoTransactions.get(0);
                if (GraphOperation.Update.equals((Object)doTransaction.getOperation()) && GraphOperation.Update.equals((Object)undoTransaction.getOperation())) {
                    return this.isLayoutTransaction(view, doTransaction);
                }
            }
        }
        return false;
    }

    private boolean isLayoutTransaction(String view, GraphTransaction transaction) {
        Set entityIDs = transaction.getEntityIDs();
        for (EntityID entityID : entityIDs) {
            if (transaction.getCenter(view, entityID) == null) continue;
            return true;
        }
        Set linkIDs = transaction.getLinkIDs();
        for (LinkID linkID : linkIDs) {
            if (transaction.getPath(view, linkID) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isMergeCandidate(Command cmd) {
        if (cmd instanceof UndoRedoBatches) {
            UndoRedoBatches batches = (UndoRedoBatches)cmd;
            GraphTransactionBatch doBatch = batches.getDoBatch();
            List transactions = doBatch.getTransactions();
            for (GraphTransaction transaction : transactions) {
                if (!this.isNeedingLayout(transaction)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNeedingLayout(GraphTransaction transaction) {
        Map pinned;
        if (GraphOperation.Update.equals((Object)transaction.getOperation()) && (pinned = transaction.getPinned()) != null && !pinned.isEmpty()) {
            return true;
        }
        return GraphOperation.Add.equals((Object)transaction.getOperation()) && transaction.needsLayout();
    }

    private void mergeCenters(String view, Collection<EntityID> entityIDs, Map<String, Map<EntityID, Point>> oldCenters, Map<EntityID, Point> centers) {
        if (centers != null) {
            for (EntityID entityID : entityIDs) {
                Point center = centers.get(entityID);
                if (center == null) continue;
                this.updateCenter(oldCenters, view, entityID, center);
                centers.remove(entityID);
            }
        }
    }

    private void cleanup(String view, LayoutInfoPair layoutInfoPair) {
        Map<EntityID, Point> beforeCenters = layoutInfoPair.Before.Centers.get(view);
        Map<EntityID, Point> afterCenters = layoutInfoPair.After.Centers.get(view);
        if (beforeCenters != null && afterCenters != null) {
            afterCenters.keySet().retainAll(beforeCenters.keySet());
            beforeCenters.keySet().retainAll(afterCenters.keySet());
            if (afterCenters.isEmpty()) {
                layoutInfoPair.After.Centers.remove(view);
                layoutInfoPair.Before.Centers.remove(view);
            }
        }
        Map<LinkID, List<Point>> beforePaths = layoutInfoPair.Before.Paths.get(view);
        Map<LinkID, List<Point>> afterPaths = layoutInfoPair.After.Paths.get(view);
        if (beforePaths != null && afterPaths != null) {
            afterPaths.keySet().retainAll(beforePaths.keySet());
            beforePaths.keySet().retainAll(afterPaths.keySet());
            if (afterPaths.isEmpty()) {
                layoutInfoPair.After.Paths.remove(view);
                layoutInfoPair.Before.Paths.remove(view);
            }
        }
    }

    private void updateCenter(Map<String, Map<EntityID, Point>> oldCenters, String view, EntityID id, Point center) {
        Map<EntityID, Point> centers = oldCenters.get(view);
        if (centers == null) {
            centers = new HashMap<EntityID, Point>();
            oldCenters.put(view, centers);
        }
        centers.put(id, center);
    }

    private void mergePaths(String view, Collection<LinkID> linkIDs, Map<String, Map<LinkID, List<Point>>> oldPaths, Map<LinkID, List<Point>> paths) {
        if (paths != null) {
            for (LinkID linkID : linkIDs) {
                List<Point> path = paths.get(linkID);
                if (path == null) continue;
                this.updatePath(oldPaths, view, linkID, path);
                paths.remove(linkID);
            }
        }
    }

    private void updatePath(Map<String, Map<LinkID, List<Point>>> oldPaths, String view, LinkID id, List<Point> path) {
        Map<LinkID, List<Point>> paths = oldPaths.get(view);
        if (paths == null) {
            paths = new HashMap<LinkID, List<Point>>();
            oldPaths.put(view, paths);
        }
        paths.put(id, STRAIGHT_PATH);
    }

    private void updateLayoutCommand(Command command, LayoutInfoPair layoutInfoPair) {
        UndoRedoBatches batches = (UndoRedoBatches)command;
        GraphTransactionBatch doBatch = batches.getDoBatch();
        GraphTransactionBatch undoBatch = batches.getUndoBatch();
        boolean significant = this.isSignificant(layoutInfoPair);
        batches.setUndoBatch(this.createBatch(undoBatch.getDescription(), layoutInfoPair.Before, significant));
        batches.setDoBatch(this.createBatch(doBatch.getDescription(), layoutInfoPair.After, significant));
    }

    private GraphTransactionBatch createBatch(SimilarStrings description, LayoutInfo layoutInfo, boolean significant) {
        Collection<MaltegoEntity> entities = this.createEntityUpdates(layoutInfo.Centers);
        Collection<MaltegoLink> links = this.createLinkUpdates(layoutInfo.Paths);
        GraphTransaction transaction = GraphTransactions.create((GraphOperation)GraphOperation.Update, entities, links, layoutInfo.Centers, layoutInfo.Paths, (Map)Collections.EMPTY_MAP, null, (boolean)false);
        return new GraphTransactionBatch(description, significant, new GraphTransaction[]{transaction});
    }

    private boolean isSignificant(LayoutInfoPair layoutInfoPair) {
        String view;
        for (Map.Entry<String, Map<EntityID, Point>> entry : layoutInfoPair.Before.Centers.entrySet()) {
            view = entry.getKey();
            for (Map.Entry<EntityID, Point> entry2 : entry.getValue().entrySet()) {
                Point centerBefore = entry2.getValue();
                Point centerAfter = layoutInfoPair.After.Centers.get(view).get(entry2.getKey());
                if (Math.abs(centerAfter.x - centerBefore.x) < 10 && Math.abs(centerAfter.y - centerBefore.y) < 10) continue;
                return true;
            }
        }
        for (Map.Entry<String, Map<Object, Object>> entry : layoutInfoPair.Before.Paths.entrySet()) {
            view = entry.getKey();
            for (Map.Entry<Object, Object> entry3 : entry.getValue().entrySet()) {
                List pathBefore = (List)entry3.getValue();
                List<Point> pathAfter = layoutInfoPair.After.Paths.get(view).get(entry3.getKey());
                if (pathBefore.size() == pathAfter.size()) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<MaltegoEntity> createEntityUpdates(Map<String, Map<EntityID, Point>> centers) {
        HashSet<EntityID> guids = new HashSet<EntityID>();
        for (Map.Entry<String, Map<EntityID, Point>> entry : centers.entrySet()) {
            guids.addAll(entry.getValue().keySet());
        }
        ArrayList<MaltegoEntity> entityUpdates = new ArrayList<MaltegoEntity>();
        for (EntityID guid : guids) {
            entityUpdates.add((MaltegoEntity)new EntityUpdate(guid));
        }
        return entityUpdates;
    }

    private Collection<MaltegoLink> createLinkUpdates(Map<String, Map<LinkID, List<Point>>> paths) {
        HashSet<LinkID> guids = new HashSet<LinkID>();
        for (Map.Entry<String, Map<LinkID, List<Point>>> entry : paths.entrySet()) {
            guids.addAll(entry.getValue().keySet());
        }
        ArrayList<MaltegoLink> linkUpdates = new ArrayList<MaltegoLink>();
        for (LinkID guid : guids) {
            linkUpdates.add((MaltegoLink)new LinkUpdate(guid));
        }
        return linkUpdates;
    }

    private boolean isEmpty(LayoutInfoPair layoutInfoPair) {
        return layoutInfoPair.Before.Centers.isEmpty() && layoutInfoPair.Before.Paths.isEmpty() && layoutInfoPair.After.Centers.isEmpty() && layoutInfoPair.After.Paths.isEmpty();
    }

    private String getView(LayoutInfoPair layoutInfoPair) {
        if (!layoutInfoPair.After.Centers.isEmpty()) {
            return layoutInfoPair.After.Centers.keySet().iterator().next();
        }
        if (!layoutInfoPair.After.Paths.isEmpty()) {
            return layoutInfoPair.After.Paths.keySet().iterator().next();
        }
        return null;
    }

    private void layoutMerged() {
        this._combinableLayouts = this._combinableLayouts < 5 ? ++this._combinableLayouts : 0;
        this._lastMergeTime = System.currentTimeMillis();
    }

    private int getCombinableLayouts() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this._lastMergeTime > 2000L) {
            this._combinableLayouts = 0;
        }
        return this._combinableLayouts;
    }

    private static class MergePlaceHolder
    extends Command {
        private final String _view;

        public MergePlaceHolder(String view) {
            this._view = view;
        }

        public String getView() {
            return this._view;
        }

        public void execute() {
        }

        public void undo() {
        }

        public String getDescription() {
            return "Layout merge placeholder (" + this._view + ")";
        }

        public boolean isSignificant() {
            return false;
        }
    }

    private class LayoutInfoPair {
        LayoutInfo Before;
        LayoutInfo After;

        private LayoutInfoPair() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("LayoutInfoPair:\n");
            sb.append("  Before:\n").append(this.Before);
            sb.append("  After:\n").append(this.After);
            return sb.toString();
        }
    }

    private class LayoutInfo {
        Map<String, Map<EntityID, Point>> Centers;
        Map<String, Map<LinkID, List<Point>>> Paths;

        private LayoutInfo() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("   Centers:\n");
            for (Map.Entry<String, Map<EntityID, Point>> entry : this.Centers.entrySet()) {
                sb.append("    ").append(entry.getKey()).append("\n");
                for (Map.Entry<EntityID, Point> entry2 : entry.getValue().entrySet()) {
                    sb.append("    ").append(entry2.getKey()).append(":");
                    sb.append(entry2.getValue()).append("\n");
                }
            }
            sb.append("   Paths:\n");
            for (Map.Entry<String, Map<Object, Object>> entry : this.Paths.entrySet()) {
                sb.append("    ").append(entry.getKey()).append("\n");
                for (Map.Entry<Object, Object> entry3 : entry.getValue().entrySet()) {
                    sb.append("    ").append(entry3.getKey()).append(":");
                    sb.append(entry3.getValue()).append("\n");
                }
            }
            return sb.toString();
        }
    }
}

