/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.logs;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.core.startup.logging.NbFormatter;

public class LogFormatter
extends Formatter {
    public static void register() {
        Handler[] handlers;
        LogFormatter formatter = new LogFormatter();
        Logger logger = Logger.getLogger("");
        for (Handler handler : handlers = logger.getHandlers()) {
            handler.setFormatter(formatter);
        }
    }

    @Override
    public String format(LogRecord record) {
        String logMsg = NbFormatter.FORMATTER.format(record);
        StringBuilder sb = new StringBuilder();
        Instant instant = Instant.ofEpochMilli(record.getMillis());
        ZonedDateTime timestamp = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        sb.append(timestamp.toLocalTime().toString());
        sb.append(' ');
        sb.append(logMsg);
        return sb.toString();
    }
}

