/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactoryapi;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.imgfactoryapi.IconNameMapping;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.VirtualIcon;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.NamedThreadFactory;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ThreadUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public abstract class IconRegistry {
    public static final String PROP_ADDED = "addedIcon";
    public static final String PROP_REMOVED_ICON = "removedIcon";
    public static final String PROP_REMOVED_CATEGORY = "removedCategory";
    public static final String PROP_RENAMED = "renamedIcon";
    public static final String PROP_REPLACED_ICONSIZE = "replacedIconSize";
    public static final String PROP_ALIASES_CHANGED = "aliasesChanged";
    public static final String PROP_ALIAS_ADDED = "aliasAdded";
    public static final String PROP_ALIAS_REMOVED = "aliasRemoved";
    public static final String PROP_HUB_ITEMS_CHANGED = "hubItemsChanged";
    public static final String PROP_HUB_ITEM_ADDED = "hubItemAdded";
    public static final String PROP_HUB_ITEM_REMOVED = "hubItemRemoved";
    private static final Executor EXECUTOR = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("Resource Icons"));
    private static IconRegistry _default;
    private final Map<RegistryIcon, Set<IconSize>> cachedIcons = new HashMap<RegistryIcon, Set<IconSize>>();

    public static synchronized IconRegistry getDefault() {
        if (_default == null && (_default = (IconRegistry)Lookup.getDefault().lookup(IconRegistry.class)) == null) {
            throw new IllegalStateException("No icon registries found.");
        }
        return _default;
    }

    public static synchronized IconRegistry forGraphID(GraphID graphID) {
        IconRegistry registry = null;
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID, (boolean)false);
        if (gud != null) {
            String key = IconRegistry.class.getName();
            registry = (IconRegistry)gud.get((Object)key);
        }
        return registry != null ? registry : IconRegistry.getDefault();
    }

    public static synchronized void associate(GraphID graphID, IconRegistry registry) {
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        String key = IconRegistry.class.getName();
        gud.put((Object)key, (Object)registry);
    }

    public abstract RegistryIcon addFromImages(String var1, String var2, Map<IconSize, Image> var3) throws IOException;

    public abstract RegistryIcon addFromFiles(String var1, String var2, Map<IconSize, FileObject> var3) throws IOException;

    protected abstract void removeIcon(RegistryIcon var1) throws IOException;

    public abstract void removeCategory(String var1) throws IOException;

    public abstract List<RegistryIcon> getIcons();

    public abstract List<RegistryIcon> getIcons(String var1);

    public abstract boolean contains(RegistryIcon var1);

    public abstract Set<String> getCategories();

    public abstract Set<String> getIconNames(String var1);

    public abstract RegistryIcon rename(RegistryIcon var1, String var2) throws IOException;

    public abstract void replace(RegistryIcon var1, IconSize var2, BufferedImage var3) throws IOException;

    public abstract void setAliases(RegistryIcon var1, Set<String> var2) throws IOException;

    public abstract void addAlias(RegistryIcon var1, String var2) throws IOException;

    public abstract void removeAlias(RegistryIcon var1, String var2) throws IOException;

    public abstract void setHubItems(RegistryIcon var1, Set<String> var2) throws IOException;

    public abstract void addHubItem(RegistryIcon var1, String var2) throws IOException;

    public abstract void removeHubItem(RegistryIcon var1, String var2) throws IOException;

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    public abstract Optional<Image> loadImage(RegistryIcon var1, IconSize var2);

    public Optional<Image> loadImage(RegistryIcon icon, IconSize size, ImageCallback cb) {
        return this.loadImageAsync(icon, size, cb);
    }

    public Optional<Image> loadImage(String imageKey, IconSize size, ImageCallback cb) {
        Args.notNullOrBlank((String)imageKey, (String)"iconString");
        Args.notNull((Object)size, (String)"size");
        return VirtualIcon.parse(imageKey).flatMap(icon -> this.loadImage((VirtualIcon)icon, size, cb));
    }

    public Optional<Image> loadImage(String iconCategory, String iconName, IconSize size, ImageCallback cb) {
        Args.notNullOrBlank((String)iconName, (String)"iconName");
        Args.notNull((Object)size, (String)"size");
        VirtualIcon virtualIcon = new VirtualIcon(iconCategory, iconName);
        return this.loadImage(virtualIcon, size, cb);
    }

    public Optional<Image> loadImage(VirtualIcon virtualIcon, IconSize size, ImageCallback cb) {
        Args.notNull((Object)virtualIcon, (String)"virtualIcon");
        Args.notNull((Object)size, (String)"size");
        return this.findRegistryIcon(virtualIcon).flatMap(registryIcon -> this.loadImage((RegistryIcon)registryIcon, size, cb));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(RegistryIcon icon) throws IOException {
        Map<RegistryIcon, Set<IconSize>> map = this.cachedIcons;
        synchronized (map) {
            this.cachedIcons.remove(icon);
        }
        this.removeIcon(icon);
    }

    public Set<String> getSortedCategories() {
        TreeSet<String> categories = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        categories.addAll(this.getCategories());
        return categories;
    }

    public List<RegistryIcon> getSortedIcons() {
        ArrayList<RegistryIcon> icons = new ArrayList<RegistryIcon>(this.getIcons());
        Collections.sort(icons);
        return icons;
    }

    public Optional<RegistryIcon> findRegistryIcon(String imageString) {
        Args.notNullOrBlank((String)imageString, (String)"imageString");
        return VirtualIcon.parse(imageString).flatMap(this::findRegistryIcon);
    }

    public Optional<RegistryIcon> findRegistryIcon(VirtualIcon virtualIcon) {
        Args.notNull((Object)virtualIcon, (String)"virtualIcon");
        Set<String> searchCategories = virtualIcon.getCategory().flatMap(this::getCorrectCaseCategory).map(category -> new LinkedHashSet<String>(Collections.singleton(category))).orElse(this.getCategories());
        String nameOrAlias = virtualIcon.getNameOrAlias();
        nameOrAlias = IconNameMapping.getNewIconName(nameOrAlias);
        return this.getRegistryIcon(searchCategories, nameOrAlias);
    }

    protected Optional<RegistryIcon> getRegistryIcon(Set<String> searchCategories, String nameOrAlias) {
        Args.notNull(searchCategories, (String)"searchCategories");
        Args.notNullOrBlank((String)nameOrAlias, (String)"nameOrAlias");
        List icons = searchCategories.stream().map(this::getIcons).flatMap(Collection::stream).collect(Collectors.toList());
        for (RegistryIcon icon : icons) {
            String iconName = icon.getName();
            if (!StringUtilities.equalsIgnoreCase((String)iconName, (String)nameOrAlias)) continue;
            return Optional.of(icon);
        }
        for (RegistryIcon icon : icons) {
            for (String iconAlias : icon.getAliases()) {
                if (!StringUtilities.equalsIgnoreCase((String)iconAlias, (String)nameOrAlias)) continue;
                return Optional.of(icon);
            }
        }
        return Optional.empty();
    }

    public Optional<String> getCorrectCaseCategory(String category) {
        return this.getCorrectCase(this.getCategories(), category);
    }

    protected Optional<RegistryIcon> getCorrectCaseRegistryIcon(String category, String name) {
        return this.getIcons().stream().filter(icon -> StringUtilities.equalsIgnoreCase((String)category, (String)icon.getCategory()) && StringUtilities.equalsIgnoreCase((String)name, (String)icon.getName())).findAny();
    }

    public Map<IconSize, Image> loadImages(RegistryIcon icon) throws IOException {
        EnumMap<IconSize, Image> images = new EnumMap<IconSize, Image>(IconSize.class);
        for (IconSize size : IconSize.values()) {
            this.loadImage(icon, size).ifPresent(image -> images.put(size, (Image)image));
        }
        return images;
    }

    public boolean existsCaseInsensitive(String iconCategory, String iconNameOrAlias) {
        Args.notNullOrBlank((String)iconNameOrAlias, (String)"iconNameOrAlias");
        return this.findRegistryIcon(new VirtualIcon(iconCategory, iconNameOrAlias)).isPresent();
    }

    protected String[] getSizeNames(String iconName) {
        Args.notNullOrBlank((String)iconName, (String)"iconName");
        String[] names = new String[IconSize.values().length];
        int num = 0;
        for (IconSize iconSize : IconSize.values()) {
            names[num++] = iconName + iconSize.getPostfix();
        }
        return names;
    }

    protected Optional<String> getCorrectCase(Collection<String> strings, String string) {
        if (strings == null || string == null) {
            return Optional.empty();
        }
        Optional<String> existingCategory = strings.stream().filter(str -> StringUtilities.equalsIgnoreCase((String)string, (String)str)).findFirst();
        return Optional.of(existingCategory.orElse(string));
    }

    protected RegistryIcon toRegistryIcon(String category, String name, Set<String> aliases, Set<String> hubItems) {
        Args.notNullOrBlank((String)category, (String)"category");
        Args.notNullOrBlank((String)name, (String)"name");
        Args.notNull(aliases, (String)"aliases");
        Args.notNull(hubItems, (String)"hubItems");
        return new RegistryIcon(category, name, aliases, hubItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<Image> loadImageAsync(RegistryIcon icon, IconSize size, ImageCallback cb) {
        Args.notNull((Object)icon, (String)"icon");
        Args.notNull((Object)size, (String)"size");
        if (cb == null) {
            return this.loadImage(icon, size);
        }
        Map<RegistryIcon, Set<IconSize>> map = this.cachedIcons;
        synchronized (map) {
            Set<IconSize> sizes = this.cachedIcons.get(icon);
            if (sizes != null && sizes.contains(size)) {
                Optional<Image> imgOpt = this.loadImage(icon, size);
                ThreadUtil.safeRun((boolean)cb.needAwtThread(), () -> cb.imageReady((Image)imgOpt.orElse(null)));
                return imgOpt;
            }
        }
        EXECUTOR.execute(() -> {
            Runnable runnable;
            try {
                Optional<Image> imgOpt = this.loadImage(icon, size);
                if (imgOpt.isPresent()) {
                    this.markCached(icon, size);
                }
                runnable = () -> cb.imageReady((Image)imgOpt.orElse(null));
            }
            catch (Exception ex) {
                runnable = () -> cb.imageFailed(ex);
            }
            ThreadUtil.safeRun((boolean)cb.needAwtThread(), (Runnable)runnable);
        });
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markCached(RegistryIcon icon, IconSize size) {
        Map<RegistryIcon, Set<IconSize>> map = this.cachedIcons;
        synchronized (map) {
            Set<IconSize> cachedSizes = this.cachedIcons.get(icon);
            if (cachedSizes == null) {
                cachedSizes = new HashSet<IconSize>();
                this.cachedIcons.put(icon, cachedSizes);
            }
            cachedSizes.add(size);
        }
    }
}

