/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.imex;

import com.paterva.maltego.importexport.ConfigNode;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.seeds.ui.imex.HubSeedConfig;
import com.paterva.maltego.seeds.ui.imex.HubSeedInstalledInfo;
import java.awt.Image;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class HubSeedNode
extends ConfigNode {
    private HubSeedConfig _config;

    public HubSeedNode(HubSeedConfig config, HubSeedDescriptor seed, HubSeedInstalledInfo existInfo) {
        this(seed, new InstanceContent(), existInfo);
        this._config = config;
    }

    private HubSeedNode(HubSeedDescriptor seed, InstanceContent content, HubSeedInstalledInfo existInfo) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)seed);
        content.add((Object)this);
        String displayName = seed.getDisplayName();
        if (existInfo != null && existInfo.exist(seed)) {
            displayName = "<installed> " + displayName;
        }
        this.setDisplayName(displayName);
        HubSeedUrl url = seed.getGrantedHubSeedUrls().isEmpty() ? null : (HubSeedUrl)seed.getGrantedHubSeedUrls().get(0);
        this.setShortDescription(url != null ? url.getUrl() : "");
    }

    public void setSelectedNonRecursive(Boolean selected) {
        if (!this.isSelected().equals(selected)) {
            super.setSelectedNonRecursive(selected);
            HubSeedDescriptor seed = (HubSeedDescriptor)this.getLookup().lookup(HubSeedDescriptor.class);
            if (selected.booleanValue()) {
                this._config.select(seed);
            } else {
                this._config.unselect(seed);
            }
        }
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/TransformSeed.png");
    }
}

