/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.isg.pyramidio;

import gov.nist.isg.archiver.FilesArchiver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DziFile {
    private final int tileSize;
    private final int overlap;
    private final String format;
    private final int width;
    private final int height;

    public DziFile(int tileSize, int overlap, String format, int width, int height) {
        this.tileSize = tileSize;
        this.overlap = overlap;
        this.format = format;
        this.width = width;
        this.height = height;
    }

    public DziFile(File dziFile) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(dziFile);
            Element imageNode = doc.getDocumentElement();
            if (!"Image".equals(imageNode.getNodeName())) {
                throw new IOException("Unsupported dzi file.");
            }
            this.tileSize = Integer.parseInt(imageNode.getAttribute("TileSize"));
            this.overlap = Integer.parseInt(imageNode.getAttribute("Overlap"));
            this.format = imageNode.getAttribute("Format");
            NodeList childNodes = imageNode.getChildNodes();
            int length = childNodes.getLength();
            String w = null;
            String h = null;
            for (int i = 0; i < length; ++i) {
                Node node = childNodes.item(i);
                if (!"Size".equals(node.getNodeName())) continue;
                NamedNodeMap attributes = node.getAttributes();
                w = attributes.getNamedItem("Width").getNodeValue();
                h = attributes.getNamedItem("Height").getNodeValue();
            }
            this.width = Integer.parseInt(w);
            this.height = Integer.parseInt(h);
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new IOException(ex);
        }
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public String getFormat() {
        return this.format;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxLevel() {
        int maxDim = Math.max(this.width, this.height);
        return (int)Math.ceil(Math.log(maxDim) / Math.log(2.0));
    }

    public void write(File file) throws FileNotFoundException, IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(file));){
            osw.write(this.toXml());
        }
    }

    public void write(String name, FilesArchiver archiver) throws IOException {
        archiver.appendFile(name, (FilesArchiver.FileAppender)new FilesArchiver.FileAppender<Void>(){

            public Void append(OutputStream outputStream) throws IOException {
                try (OutputStreamWriter out = new OutputStreamWriter(outputStream, Charset.forName("UTF-8"));){
                    out.write(DziFile.this.toXml());
                }
                return null;
            }
        });
    }

    private String toXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        sb.append("<Image TileSize=\"").append(this.tileSize).append("\" Overlap=\"").append(this.overlap).append("\" Format=\"").append(this.format).append("\" xmlns=\"http://schemas.microsoft.com/deepzoom/2009\">\n");
        sb.append("<Size Width=\"").append(this.width).append("\" Height=\"").append(this.height).append("\" />\n");
        sb.append("</Image>\n");
        return sb.toString();
    }
}

