/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.prompts.input;

import com.maltego.tx3.java.api.execution.InputPrompt;
import com.maltego.tx3.java.api.execution.TransformRunInputPromptEvent;
import com.maltego.tx3.java.api.execution.TransformRunPromptResponse;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.protocol.v3.JButtonAutoAccept;
import com.paterva.maltego.transform.protocol.v3.api.prompts.TransformPromptContext;
import com.paterva.maltego.transform.protocol.v3.api.remote.V3ValueConverter;
import com.paterva.maltego.transform.runner.inputs.TransformInputsForm;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DataSources;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.editing.ComponentFactories;
import com.paterva.maltego.typing.editing.form.VerticalFlowLayout;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.TimeSpan;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;

public class TransformInputPromptDisplayer {
    private static final Logger LOG = Logger.getLogger(TransformInputPromptDisplayer.class.getName());
    private final Map<String, Object> _factorySettings = new TreeMap<String, Object>();

    public TransformInputPromptDisplayer() {
        this._factorySettings.put("showDescriptions", Boolean.FALSE);
        this._factorySettings.put("useRequiredFieldColor", Boolean.FALSE);
    }

    public TransformRunPromptResponse showTypedPrompt(TransformRunInputPromptEvent inputPrompts, TransformPromptContext context) {
        DataSources.Map promptAnswers = new DataSources.Map();
        TransformInputsForm form = this.createPopupControl(context.getTransformDisplayName(), inputPrompts, (DataSource)promptAnswers);
        Dimension size = form.getScrollPane().getPreferredSize();
        form.getScrollPane().setVerticalScrollBarPolicy(20);
        form.getScrollPane().setPreferredSize(new Dimension(size.width + form.getScrollPane().getVerticalScrollBar().getWidth(), Math.min(size.height, 500)));
        form.getScrollPane().getVerticalScrollBar().setUnitIncrement(16);
        JButtonAutoAccept okButton = new JButtonAutoAccept("Ok", inputPrompts.getTimeout());
        okButton.setActionCommand("OK");
        JButton cancelButton = new JButton("Close");
        DialogDescriptor dd = new DialogDescriptor((Object)form, "Additional Transform Input", true, new Object[]{okButton, cancelButton}, (Object)okButton, 0, HelpCtx.DEFAULT_HELP, null);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        TransformRunPromptResponse.ResponseReason reason = TransformRunPromptResponse.ResponseReason.COMPLETED;
        if (result.equals(DialogDescriptor.CLOSED_OPTION)) {
            reason = TransformRunPromptResponse.ResponseReason.CANCELLED;
        } else if (result.equals(cancelButton)) {
            reason = TransformRunPromptResponse.ResponseReason.CANCELLED;
        } else if (result.equals(okButton)) {
            reason = okButton.getTimedOut() ? TransformRunPromptResponse.ResponseReason.TIMED_OUT : TransformRunPromptResponse.ResponseReason.COMPLETED;
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (DisplayDescriptor input : this.getInputs(inputPrompts)) {
            Object answer = promptAnswers.getValue((PropertyDescriptor)input);
            Class classTo = input.getTypeDescriptor().getType();
            if (classTo == DateTime.class || classTo == DateRange.class || classTo == Date.class || classTo == Date[].class || classTo == TimeSpan.class) {
                try {
                    answer = V3ValueConverter.write((Object)answer, (Class)classTo);
                }
                catch (Exception ex) {
                    Logger.getLogger(TransformInputPromptDisplayer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            results.put(input.getName(), answer);
        }
        return new TransformRunPromptResponse(reason, results);
    }

    private TransformInputsForm createPopupControl(String transformDisplayName, TransformRunInputPromptEvent inputPrompts, DataSource dataSource) {
        String headingLabel = String.format("Transform %s is requesting the following input: ", transformDisplayName);
        DisplayDescriptorCollection inputs = this.getInputs(inputPrompts);
        Component content = this.createContentControl(dataSource, inputs);
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        content.setBackground(laf.getColor("transform-manager-lowlight-bg"));
        TransformInputsForm form = new TransformInputsForm(headingLabel, false);
        JTextArea msg = new JTextArea(inputPrompts.getMessage());
        msg.setWrapStyleWord(true);
        msg.setLineWrap(true);
        msg.setOpaque(false);
        msg.setEditable(false);
        msg.setFocusable(false);
        msg.setBorder(BorderFactory.createEmptyBorder(0, 6, 10, 0));
        msg.setMaximumSize(new Dimension(Integer.MAX_VALUE, msg.getPreferredSize().height));
        form.getContentPane().add((Component)msg, "Center");
        form.getContentPane().add(content);
        return form;
    }

    private Component createContentControl(DataSource ds, DisplayDescriptorCollection inputs) {
        return ComponentFactories.form(this._factorySettings).createEditingComponent(ds, (DisplayDescriptorEnumeration)inputs, null, BorderFactory.createEmptyBorder(2, 0, 2, 0), (LayoutManager)new VerticalFlowLayout(1));
    }

    private DisplayDescriptorCollection getInputs(TransformRunInputPromptEvent inputPrompts) {
        DisplayDescriptorList displayDescriptors = new DisplayDescriptorList();
        for (InputPrompt inputPrompt : inputPrompts.getInputs()) {
            TypeDescriptor typeDescriptor = TypeRegistry.getDefault().getType(inputPrompt.getType());
            if (typeDescriptor != null) {
                TransformPropertyDescriptor tpd = new TransformPropertyDescriptor(typeDescriptor.getType(), inputPrompt.getId(), inputPrompt.getDisplayName());
                if (inputPrompt.getDefaultValue() != null) {
                    tpd.setDefaultValue(inputPrompt.getDefaultValue());
                }
                displayDescriptors.add((DisplayDescriptor)tpd);
                continue;
            }
            LOG.severe("TypeDescriptor for prompt type " + inputPrompt.getType() + " not found.");
        }
        return displayDescriptors;
    }
}

