/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.prompts.choice.controls;

import com.maltego.tx3.java.api.execution.CheckboxChoicePromptControl;
import com.maltego.tx3.java.api.execution.ChoicePrompt;
import com.maltego.tx3.java.api.execution.ChoicePromptControl;
import com.maltego.tx3.java.api.execution.DropdownChoicePromptControl;
import com.maltego.tx3.java.api.execution.RadioChoicePromptControl;
import com.maltego.tx3.java.api.execution.TransformRunChoicePromptEvent;
import com.maltego.tx3.java.api.execution.TransformRunMultiChoicePromptEvent;
import com.maltego.tx3.java.api.execution.TransformRunPromptResponse;
import com.paterva.maltego.transform.protocol.v3.JButtonAutoAccept;
import com.paterva.maltego.transform.runner.inputs.TransformInputsForm;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;

public abstract class PromptControl {
    private static final int DEFAULT_COMPONENT_SPACING = 10;
    private static final int DEFAULT_COMPONENT_WIDTH = 650;
    private final JPanel rootPanel;
    private final JButton cancelButton;
    private final Integer timeout;
    private final Map<String, Object> controlMap = new HashMap<String, Object>();
    private final TransformInputsForm form;

    protected PromptControl(String transformName, String message, Integer timeout) {
        this.form = new TransformInputsForm(String.format("Transform %s is requesting the following input: ", transformName), false);
        this.rootPanel = (JPanel)this.form.getContentPane();
        this.rootPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.rootPanel.add(this.createTextPanel(message, true));
        this.cancelButton = new JButton("Close");
        this.timeout = timeout;
    }

    protected void addControls(TransformRunMultiChoicePromptEvent prompt) {
        for (ChoicePromptControl control : prompt.getControls()) {
            switch (control.getControlType()) {
                case DROPDOWN: {
                    DropdownChoicePromptControl ddControl = (DropdownChoicePromptControl)control;
                    this.addDropDownControl(ddControl);
                    break;
                }
                case CHECKBOX: {
                    CheckboxChoicePromptControl cbControl = (CheckboxChoicePromptControl)control;
                    this.addCheckboxControl(cbControl);
                    break;
                }
                case RADIO: {
                    RadioChoicePromptControl rbControl = (RadioChoicePromptControl)control;
                    this.addRadioControl(rbControl);
                }
            }
            if (this.controlMap.isEmpty() || this.controlMap.size() == prompt.getControls().size()) continue;
            this.addSeparator();
        }
        this.resize();
    }

    protected String addCheckboxControl(CheckboxChoicePromptControl control) {
        return this.addCheckboxControl(control.getControlId(), control.getLabel(), control.getDefaultOptionIds(), control.getOptions());
    }

    protected String addCheckboxControl(String controlId, String controlLabel, Collection<String> defaultOptionIds, List<ChoicePrompt> options) {
        JPanel controlPanel = this.createControlPanel(controlLabel);
        List<JCheckBox> checkboxes = this.createCheckboxes(options, defaultOptionIds);
        checkboxes.forEach(controlPanel::add);
        this.rootPanel.add(controlPanel);
        controlId = this.assignControlIdIfUnset(controlId);
        this.controlMap.put(controlId, checkboxes);
        return controlId;
    }

    protected String addDropDownControl(DropdownChoicePromptControl control) {
        return this.addDropDownControl(control.getControlId(), control.getLabel(), control.getDefaultOptionId(), control.getOptions());
    }

    protected String addDropDownControl(String controlId, String controlLabel, String defaultOptionId, List<ChoicePrompt> options) {
        JPanel controlPanel = this.createControlPanel(controlLabel);
        JComboBox<ComboBoxItem> comboBox = this.createComboBox(options, defaultOptionId);
        controlPanel.add(comboBox);
        this.rootPanel.add(controlPanel);
        controlId = this.assignControlIdIfUnset(controlId);
        this.controlMap.put(controlId, comboBox);
        return controlId;
    }

    protected String addRadioControl(RadioChoicePromptControl control) {
        return this.addRadioControl(control.getControlId(), control.getLabel(), control.getDefaultOptionId(), control.getOptions());
    }

    protected String addRadioControl(String controlId, String controlLabel, String defaultOptionId, List<ChoicePrompt> options) {
        JPanel controlPanel = this.createControlPanel(controlLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        List<JRadioButton> radioButtons = this.createRadioButtons(options, defaultOptionId, buttonGroup);
        radioButtons.forEach(controlPanel::add);
        this.rootPanel.add(controlPanel);
        controlId = this.assignControlIdIfUnset(controlId);
        this.controlMap.put(controlId, radioButtons);
        return controlId;
    }

    protected Map<String, Object> gatherResponses() {
        return this.controlMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.gatherResponse(entry.getValue())));
    }

    protected JButton[] getDefaultButtons() {
        JButton[] buttons = new JButton[]{this.timeout != null ? new JButtonAutoAccept("OK", this.timeout) : new JButton("OK"), this.getCancelButton()};
        return buttons;
    }

    public DialogDescriptor getDialogDescriptor() {
        return new DialogDescriptor((Object)this.form, "Additional Transform Input", true, (Object[])this.getDefaultButtons(), (Object)this.getDefaultButtons()[0], 0, HelpCtx.DEFAULT_HELP, null);
    }

    public abstract TransformRunPromptResponse handleResponse(Object var1);

    protected TransformRunPromptResponse.ResponseReason getReason(Object result, TransformRunPromptResponse.ResponseReason reason) {
        if (result.equals(this.getCancelButton()) || result.equals(DialogDescriptor.CLOSED_OPTION)) {
            return TransformRunPromptResponse.ResponseReason.CANCELLED;
        }
        if (result instanceof JButtonAutoAccept && ((JButtonAutoAccept)result).getTimedOut()) {
            return TransformRunPromptResponse.ResponseReason.TIMED_OUT;
        }
        return reason;
    }

    public JPanel getFormPanel() {
        return this.form;
    }

    protected Map<String, ChoicePrompt> gatherOptions(TransformRunChoicePromptEvent prompt) {
        HashMap<String, ChoicePrompt> optionsMap = new HashMap<String, ChoicePrompt>();
        if (prompt.getControl() != null && prompt.getControl().getOptions() != null) {
            optionsMap.putAll(prompt.getControl().getOptions().stream().collect(Collectors.toMap(ChoicePrompt::getId, c -> c)));
        }
        if (prompt.getOptions() != null) {
            optionsMap.putAll(prompt.getOptions().stream().collect(Collectors.toMap(ChoicePrompt::getId, c -> c)));
        }
        return optionsMap;
    }

    private void addSeparator() {
        JSeparator separator = new JSeparator();
        separator.setMaximumSize(new Dimension(Integer.MAX_VALUE, 1));
        separator.setPreferredSize(new Dimension(1, 10));
        this.rootPanel.add(separator);
    }

    void resize() {
        SwingUtilities.invokeLater(() -> {
            this.form.setPreferredSize(new Dimension(650, this.form.getPreferredSize().height));
            this.form.getScrollPane().getVerticalScrollBar().setValue(0);
            this.form.getScrollPane().setVerticalScrollBarPolicy(20);
        });
    }

    private JPanel createControlPanel(String controlLabel) {
        JPanel controlPanel = new JPanel();
        controlPanel.setAlignmentX(0.0f);
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        controlPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        if (controlLabel != null) {
            controlPanel.add(this.createTextPanel(controlLabel, false));
        }
        return controlPanel;
    }

    private JPanel createTextPanel(String text, boolean makeBold) {
        JTextArea textArea = new JTextArea(text);
        textArea.setAlignmentX(0.0f);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setOpaque(false);
        textArea.setEditable(false);
        textArea.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        if (makeBold) {
            textArea.setFont(textArea.getFont().deriveFont(1));
        }
        textArea.setFocusable(false);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentX(0.0f);
        panel.add(textArea);
        panel.setMinimumSize(new Dimension(650, panel.getPreferredSize().height));
        return panel;
    }

    private String assignControlIdIfUnset(String controlId) {
        return controlId == null ? UUID.randomUUID().toString() : controlId;
    }

    private List<JCheckBox> createCheckboxes(List<ChoicePrompt> options, Collection<String> defaultOptionIds) {
        ArrayList<JCheckBox> checkboxes = new ArrayList<JCheckBox>();
        for (ChoicePrompt choicePrompt : options) {
            boolean checked = defaultOptionIds != null && defaultOptionIds.contains(choicePrompt.getId());
            JCheckBox checkbox = new JCheckBox(choicePrompt.getDisplayName(), checked);
            checkbox.setName(choicePrompt.getId());
            checkboxes.add(checkbox);
        }
        return checkboxes;
    }

    private JComboBox<ComboBoxItem> createComboBox(List<ChoicePrompt> options, String defaultOptionId) {
        JComboBox<ComboBoxItem> comboBox = new JComboBox<ComboBoxItem>();
        int selectedIndex = 0;
        for (int i = 0; i < options.size(); ++i) {
            ChoicePrompt choicePrompt = options.get(i);
            if (defaultOptionId != null && choicePrompt.getId().equals(defaultOptionId)) {
                selectedIndex = i;
            }
            comboBox.addItem(new ComboBoxItem(choicePrompt));
        }
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setAlignmentX(0.0f);
        return comboBox;
    }

    private List<JRadioButton> createRadioButtons(List<ChoicePrompt> options, String defaultOptionId, ButtonGroup buttonGroup) {
        ArrayList<JRadioButton> radioButtons = new ArrayList<JRadioButton>();
        for (ChoicePrompt choicePrompt : options) {
            boolean checked = defaultOptionId != null && defaultOptionId.equals(choicePrompt.getId());
            JRadioButton radioButton = new JRadioButton(choicePrompt.getDisplayName(), checked);
            radioButton.setName(choicePrompt.getId());
            buttonGroup.add(radioButton);
            radioButtons.add(radioButton);
        }
        return radioButtons;
    }

    private Object gatherResponse(Object value) {
        if (value instanceof JComboBox) {
            return this.gatherComboBoxResponse((JComboBox)value);
        }
        if (value instanceof JCheckBox) {
            return this.gatherCheckBoxResponse((JCheckBox)value);
        }
        if (value instanceof List) {
            return this.gatherListResponse((List)value);
        }
        return null;
    }

    private Map<String, String> gatherComboBoxResponse(JComboBox<?> comboBox) {
        ComboBoxItem item = (ComboBoxItem)comboBox.getSelectedItem();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(item.getPrompt().getId(), item.getPrompt().getDisplayName());
        return result;
    }

    private Map<String, String> gatherCheckBoxResponse(JCheckBox checkBox) {
        if (checkBox.isSelected()) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(checkBox.getName(), checkBox.getText());
            return result;
        }
        return Collections.emptyMap();
    }

    private Map<String, String> gatherListResponse(List<?> list) {
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        if (list.get(0) instanceof JCheckBox) {
            return this.gatherCheckBoxListResponse(list);
        }
        if (list.get(0) instanceof JRadioButton) {
            return this.gatherRadioButtonListResponse(list);
        }
        return Collections.emptyMap();
    }

    private Map<String, String> gatherCheckBoxListResponse(List<JCheckBox> checkBoxes) {
        return checkBoxes.stream().filter(AbstractButton::isSelected).collect(Collectors.toMap(Component::getName, AbstractButton::getText));
    }

    private Map<String, String> gatherRadioButtonListResponse(List<JRadioButton> radioButtons) {
        return radioButtons.stream().filter(AbstractButton::isSelected).collect(Collectors.toMap(Component::getName, AbstractButton::getText));
    }

    protected JButton getCancelButton() {
        return this.cancelButton;
    }

    protected static class ComboBoxItem {
        private final ChoicePrompt prompt;
        private final String text;

        public ComboBoxItem(ChoicePrompt prompt) {
            this.prompt = prompt;
            this.text = prompt.getDisplayName();
        }

        public ChoicePrompt getPrompt() {
            return this.prompt;
        }

        public String toString() {
            return this.text;
        }
    }
}

