/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.ui.details;

import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.io.TableHeaders;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraph;
import com.paterva.maltego.graph.table.io.links.ConnectivityOptions;
import com.paterva.maltego.transforms.tabular.TabularTransformSourceRepository;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.transforms.tabular.ui.TabularTransformSourceCreator;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;

public class EditMappingsHelper {
    private EditMappingsHelper() {
    }

    public static void showMappingsDialog(TabularTransformSource transformSource, WizardDescriptor.Panel panel, String title, boolean resetLinks) {
        Args.notNull((Object)panel, (String)"panel");
        Args.notNullOrBlank((String)title, (String)"title");
        EditDialogDescriptor descriptor = new EditDialogDescriptor(panel);
        TabularGraph tabularGraph = MappingRegistry.getDefault().get(transformSource.getTabularGraphName());
        tabularGraph = new DefaultTabularGraph(tabularGraph);
        EditMappingsHelper.updateColumns(transformSource, tabularGraph);
        descriptor.putProperty("graphTable", (Object)tabularGraph);
        descriptor.putProperty("files", EditMappingsHelper.toFiles(transformSource.getSourceFiles()));
        descriptor.putProperty("defaultConnectivityOptions", (Object)ConnectivityOptions.MANUAL);
        descriptor.putProperty("hasEntitiesbeenAutoDetected", (Object)true);
        descriptor.setTitle(title);
        EditMappingsHelper.showDialog(descriptor);
        if (NotifyDescriptor.OK_OPTION.equals(descriptor.getValue())) {
            try {
                TabularTransformSourceCreator creator = TabularTransformSourceCreator.getDefault();
                EditMappingsHelper.update(creator.recreate(transformSource, tabularGraph, resetLinks));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static void updateColumns(TabularTransformSource transformSource, TabularGraph tabularGraph) {
        Args.notNull((Object)tabularGraph, (String)"tabularGraph");
        String firstFile = (String)transformSource.getSourceFiles().get(0);
        TableHeaders headers = new TableHeaders(tabularGraph, firstFile);
        if (headers.getHeaders() != null) {
            String[] columnNames = headers.getHeaders().toArray(new String[0]);
            tabularGraph.setColumnCount(columnNames.length);
            tabularGraph.setColumnNames(columnNames);
        }
    }

    private static void showDialog(EditDialogDescriptor descriptor) {
        Args.notNull((Object)descriptor, (String)"descriptor");
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)descriptor);
        dialog.setSize(new Dimension(800, 600));
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    private static List<File> toFiles(List<String> sourceFiles) {
        Args.notNull(sourceFiles, (String)"sourceFiles");
        return sourceFiles.stream().map(File::new).collect(Collectors.toList());
    }

    private static void update(TabularTransformSource source) {
        Args.notNull((Object)source, (String)"source");
        TabularTransformSourceRepository.getInstance().update((Object)source);
    }
}

