/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.types;

import com.pinkmatter.types.Converter;
import com.pinkmatter.types.Coordinate;
import com.pinkmatter.types.Geography;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.Objects;

public abstract class Area
extends Geography {
    private final Geometry _geometry;

    protected Area(Geometry geometry) {
        if (geometry == null) {
            throw new IllegalArgumentException("Geometry cannot be null");
        }
        this._geometry = geometry;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Area) {
            return this.equals((Area)obj);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + Objects.hashCode(this._geometry);
        return hash;
    }

    public boolean equals(Area area) {
        if (area == null) {
            return false;
        }
        return this._geometry.equals(area._geometry);
    }

    public String toString() {
        return this._geometry.toString();
    }

    @Override
    public Coordinate getCoordinate() {
        return Converter.fromJts(this._geometry.getCoordinate());
    }

    @Override
    public Coordinate getCentroid() {
        Point p = this._geometry.getCentroid();
        return new Coordinate(p.getY(), p.getX());
    }

    @Override
    public Coordinate[] getCoordinates() {
        return Converter.fromJts(this._geometry.getCoordinates());
    }

    @Override
    protected Geometry getGeometry() {
        return this._geometry;
    }
}

