/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -i
#include <stdint.h>
#include <limits.h>
#include <assert.h>

static const uint64_t ERROR = UINT64_MAX;

#define CHECK(n) if (n > UINT32_MAX) return ERROR;

static uint64_t parse_u32(const char *s) {
    const char *YYCURSOR = s, *YYMARKER;
    uint64_t u = 0;

    
{
	unsigned char yych;
	yych = *YYCURSOR;
	switch (yych) {
		case '0': goto yy2;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy4;
		default: goto yy1;
	}
yy1:
	++YYCURSOR;
	{ return ERROR; }
yy2:
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'B':
		case 'b': goto yy5;
		case 'X':
		case 'x': goto yy7;
		default: goto yy3;
	}
yy3:
	{ goto oct; }
yy4:
	++YYCURSOR;
	YYCURSOR -= 1;
	{ goto dec; }
yy5:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy8;
		default: goto yy6;
	}
yy6:
	YYCURSOR = YYMARKER;
	goto yy3;
yy7:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy9;
		default: goto yy6;
	}
yy8:
	++YYCURSOR;
	YYCURSOR -= 1;
	{ goto bin; }
yy9:
	++YYCURSOR;
	YYCURSOR -= 1;
	{ goto hex; }
}

bin:
    
{
	unsigned char yych;
	yych = *YYCURSOR;
	switch (yych) {
		case 0x00: goto yy11;
		case '0':
		case '1': goto yy13;
		default: goto yy12;
	}
yy11:
	++YYCURSOR;
	{ return u; }
yy12:
	++YYCURSOR;
	{ return ERROR; }
yy13:
	++YYCURSOR;
	{ u = u * 2 + (YYCURSOR[-1] - '0'); CHECK(u); goto bin; }
}

oct:
    
{
	unsigned char yych;
	yych = *YYCURSOR;
	switch (yych) {
		case 0x00: goto yy15;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7': goto yy17;
		default: goto yy16;
	}
yy15:
	++YYCURSOR;
	{ return u; }
yy16:
	++YYCURSOR;
	{ return ERROR; }
yy17:
	++YYCURSOR;
	{ u = u * 8 + (YYCURSOR[-1] - '0'); CHECK(u); goto oct; }
}

dec:
    
{
	unsigned char yych;
	yych = *YYCURSOR;
	switch (yych) {
		case 0x00: goto yy19;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy21;
		default: goto yy20;
	}
yy19:
	++YYCURSOR;
	{ return u; }
yy20:
	++YYCURSOR;
	{ return ERROR; }
yy21:
	++YYCURSOR;
	{ u = u * 10 + (YYCURSOR[-1] - '0'); CHECK(u); goto dec; }
}

hex:
    
{
	unsigned char yych;
	yych = *YYCURSOR;
	switch (yych) {
		case 0x00: goto yy23;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy25;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F': goto yy26;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy27;
		default: goto yy24;
	}
yy23:
	++YYCURSOR;
	{ return u; }
yy24:
	++YYCURSOR;
	{ return ERROR; }
yy25:
	++YYCURSOR;
	{ u = u * 16 + (YYCURSOR[-1] - '0');      CHECK(u); goto hex; }
yy26:
	++YYCURSOR;
	{ u = u * 16 + (YYCURSOR[-1] - 'A' + 10); CHECK(u); goto hex; }
yy27:
	++YYCURSOR;
	{ u = u * 16 + (YYCURSOR[-1] - 'a' + 10); CHECK(u); goto hex; }
}

}

int main() {
    assert(parse_u32("") == ERROR);
    assert(parse_u32("1234567890") == 1234567890);
    assert(parse_u32("0b1101") == 13);
    assert(parse_u32("0x7Fe") == 2046);
    assert(parse_u32("0644") == 420);
    assert(parse_u32("9999999999") == ERROR);
    return 0;
}
