% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2-cell-union.R
\name{s2_cell_union_normalize}
\alias{s2_cell_union_normalize}
\alias{s2_cell_union_contains}
\alias{s2_cell_union_intersects}
\alias{s2_cell_union_intersection}
\alias{s2_cell_union_union}
\alias{s2_cell_union_difference}
\alias{s2_covering_cell_ids}
\alias{s2_covering_cell_ids_agg}
\title{S2 cell union operators}
\usage{
s2_cell_union_normalize(x)

s2_cell_union_contains(x, y)

s2_cell_union_intersects(x, y)

s2_cell_union_intersection(x, y)

s2_cell_union_union(x, y)

s2_cell_union_difference(x, y)

s2_covering_cell_ids(
  x,
  min_level = 0,
  max_level = 30,
  max_cells = 8,
  buffer = 0,
  interior = FALSE,
  radius = s2_earth_radius_meters()
)

s2_covering_cell_ids_agg(
  x,
  min_level = 0,
  max_level = 30,
  max_cells = 8,
  buffer = 0,
  interior = FALSE,
  radius = s2_earth_radius_meters(),
  na.rm = FALSE
)
}
\arguments{
\item{x, y}{An \link[=as_s2_geography]{s2_geography} or \code{\link[=s2_cell_union]{s2_cell_union()}}.}

\item{min_level, max_level}{The minimum and maximum levels to constrain the
covering.}

\item{max_cells}{The maximum number of cells in the covering. Defaults to
8.}

\item{buffer}{A distance to buffer outside the geography}

\item{interior}{Use \code{TRUE} to force the covering inside the geography.}

\item{radius}{The radius to use (e.g., \code{\link[=s2_earth_radius_meters]{s2_earth_radius_meters()}})}

\item{na.rm}{Remove NAs prior to computing aggregate?}
}
\description{
S2 cell union operators
}
