"""rename important with importance and remove check constraint

Revision ID: 3eb96406e88d
Revises: 0409e696eeec
Create Date: 2022-09-30 19:15:05.214519+00:00

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '3eb96406e88d'
down_revision = '0409e696eeec'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('vulnerability', sa.Column('epss', sa.Float(), nullable=True))
    op.execute("ALTER TABLE vulnerability DROP COLUMN IF EXISTS risk")
    op.execute("ALTER TABLE vulnerability ADD COLUMN IF NOT EXISTS risk INTEGER NULL")
    op.execute("ALTER TABLE workspace DROP COLUMN IF EXISTS important")
    op.execute("ALTER TABLE host DROP COLUMN IF EXISTS important")
    op.execute("ALTER TABLE workspace ADD COLUMN IF NOT EXISTS importance INTEGER NULL DEFAULT 0")
    op.execute("ALTER TABLE host ADD COLUMN IF NOT EXISTS importance INTEGER NULL DEFAULT 0")
    op.execute("ALTER TABLE vulnerability DROP CONSTRAINT IF EXISTS check_vulnerability_risk")
    op.drop_constraint('uix_reference_name_vulnerability_workspace', 'reference', type_='unique')
    op.create_unique_constraint('uix_reference_name_type_vulnerability_workspace', 'reference',
                                ['name', 'type', 'workspace_id'])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('uix_reference_name_type_vulnerability_workspace', 'reference', type_='unique')
    op.create_unique_constraint('uix_reference_name_vulnerability_workspace', 'reference', ['name', 'workspace_id'])
    op.drop_column('workspace', 'importance')
    op.drop_column('host', 'importance')
    op.execute("ALTER TABLE host ADD COLUMN important BOOLEAN NULL DEFAULT FALSE")
    op.drop_column('vulnerability', 'epss')
    # ### end Alembic commands ###
