# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dashboard import DashboardManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDashboardManagementGrafanaOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DashboardManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_grafana_get(self, resource_group):
        response = self.client.grafana.get(
            resource_group_name=resource_group.name,
            workspace_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_grafana_begin_create(self, resource_group):
        response = self.client.grafana.begin_create(
            resource_group_name=resource_group.name,
            workspace_name="str",
            request_body_parameters={
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "location": "str",
                "name": "str",
                "properties": {
                    "apiKey": "str",
                    "autoGeneratedDomainNameLabelScope": "str",
                    "creatorCanAdmin": "str",
                    "deterministicOutboundIP": "str",
                    "endpoint": "str",
                    "enterpriseConfigurations": {"marketplaceAutoRenew": "str", "marketplacePlanId": "str"},
                    "grafanaConfigurations": {
                        "security": {"csrfAlwaysCheck": bool},
                        "smtp": {
                            "enabled": bool,
                            "fromAddress": "str",
                            "fromName": "str",
                            "host": "str",
                            "password": "str",
                            "skipVerify": bool,
                            "startTLSPolicy": "str",
                            "user": "str",
                        },
                        "snapshots": {"externalEnabled": bool},
                        "unifiedAlertingScreenshots": {"captureEnabled": bool},
                        "users": {"editorsCanAdmin": bool, "viewersCanEdit": bool},
                    },
                    "grafanaIntegrations": {
                        "azureMonitorWorkspaceIntegrations": [{"azureMonitorWorkspaceResourceId": "str"}]
                    },
                    "grafanaMajorVersion": "str",
                    "grafanaPlugins": {"str": {"pluginId": "str"}},
                    "grafanaVersion": "str",
                    "outboundIPs": ["str"],
                    "privateEndpointConnections": [
                        {
                            "id": "str",
                            "name": "str",
                            "properties": {
                                "privateLinkServiceConnectionState": {
                                    "actionsRequired": "str",
                                    "description": "str",
                                    "status": "str",
                                },
                                "groupIds": ["str"],
                                "privateEndpoint": {"id": "str"},
                                "provisioningState": "str",
                            },
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "publicNetworkAccess": "str",
                    "zoneRedundancy": "str",
                },
                "sku": {"name": "str", "size": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_grafana_begin_update(self, resource_group):
        response = self.client.grafana.begin_update(
            resource_group_name=resource_group.name,
            workspace_name="str",
            request_body_parameters={
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "properties": {
                    "apiKey": "str",
                    "creatorCanAdmin": "str",
                    "deterministicOutboundIP": "str",
                    "enterpriseConfigurations": {"marketplaceAutoRenew": "str", "marketplacePlanId": "str"},
                    "grafanaConfigurations": {
                        "security": {"csrfAlwaysCheck": bool},
                        "smtp": {
                            "enabled": bool,
                            "fromAddress": "str",
                            "fromName": "str",
                            "host": "str",
                            "password": "str",
                            "skipVerify": bool,
                            "startTLSPolicy": "str",
                            "user": "str",
                        },
                        "snapshots": {"externalEnabled": bool},
                        "unifiedAlertingScreenshots": {"captureEnabled": bool},
                        "users": {"editorsCanAdmin": bool, "viewersCanEdit": bool},
                    },
                    "grafanaIntegrations": {
                        "azureMonitorWorkspaceIntegrations": [{"azureMonitorWorkspaceResourceId": "str"}]
                    },
                    "grafanaMajorVersion": "str",
                    "grafanaPlugins": {"str": {"pluginId": "str"}},
                    "publicNetworkAccess": "str",
                    "zoneRedundancy": "str",
                },
                "sku": {"name": "str", "size": "str"},
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_grafana_begin_delete(self, resource_group):
        response = self.client.grafana.begin_delete(
            resource_group_name=resource_group.name,
            workspace_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_grafana_list_by_resource_group(self, resource_group):
        response = self.client.grafana.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_grafana_list(self, resource_group):
        response = self.client.grafana.list()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_grafana_check_enterprise_details(self, resource_group):
        response = self.client.grafana.check_enterprise_details(
            resource_group_name=resource_group.name,
            workspace_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_grafana_fetch_available_plugins(self, resource_group):
        response = self.client.grafana.fetch_available_plugins(
            resource_group_name=resource_group.name,
            workspace_name="str",
        )

        # please add some check logic here by yourself
        # ...
