// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -emit-llvm -fopenmp -triple=x86_64-unknown-linux-gnu \
// RUN:   -DORDERING=seq_cst -o - %s \
// RUN: | FileCheck %s --check-prefix=SEQ_CST
// RUN: %clang_cc1 -emit-llvm -fopenmp -triple=x86_64-unknown-linux-gnu \
// RUN:   -DORDERING=acq_rel -o - %s \
// RUN: | FileCheck %s --check-prefix=ACQ_REL
// RUN: %clang_cc1 -emit-llvm -fopenmp -triple=x86_64-unknown-linux-gnu \
// RUN:   -DORDERING=relaxed -o - %s \
// RUN: | FileCheck %s --check-prefix=RELAXED

#pragma omp requires atomic_default_mem_order(ORDERING)

// SEQ_CST-LABEL: define dso_local void @_Z3fooPi(
// SEQ_CST-SAME: ptr noundef [[X:%.*]]) #[[ATTR0:[0-9]+]] {
// SEQ_CST-NEXT:  [[ENTRY:.*:]]
// SEQ_CST-NEXT:    [[X_ADDR:%.*]] = alloca ptr, align 8
// SEQ_CST-NEXT:    store ptr [[X]], ptr [[X_ADDR]], align 8
// SEQ_CST-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// SEQ_CST-NEXT:    [[TMP1:%.*]] = atomicrmw add ptr [[TMP0]], i32 1 seq_cst, align 4
// SEQ_CST-NEXT:    call void @__kmpc_flush(ptr @[[GLOB1:[0-9]+]])
// SEQ_CST-NEXT:    ret void
//
// ACQ_REL-LABEL: define dso_local void @_Z3fooPi(
// ACQ_REL-SAME: ptr noundef [[X:%.*]]) #[[ATTR0:[0-9]+]] {
// ACQ_REL-NEXT:  [[ENTRY:.*:]]
// ACQ_REL-NEXT:    [[X_ADDR:%.*]] = alloca ptr, align 8
// ACQ_REL-NEXT:    store ptr [[X]], ptr [[X_ADDR]], align 8
// ACQ_REL-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// ACQ_REL-NEXT:    [[TMP1:%.*]] = atomicrmw add ptr [[TMP0]], i32 1 release, align 4
// ACQ_REL-NEXT:    call void @__kmpc_flush(ptr @[[GLOB1:[0-9]+]])
// ACQ_REL-NEXT:    ret void
//
// RELAXED-LABEL: define dso_local void @_Z3fooPi(
// RELAXED-SAME: ptr noundef [[X:%.*]]) #[[ATTR0:[0-9]+]] {
// RELAXED-NEXT:  [[ENTRY:.*:]]
// RELAXED-NEXT:    [[X_ADDR:%.*]] = alloca ptr, align 8
// RELAXED-NEXT:    store ptr [[X]], ptr [[X_ADDR]], align 8
// RELAXED-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// RELAXED-NEXT:    [[TMP1:%.*]] = atomicrmw add ptr [[TMP0]], i32 1 monotonic, align 4
// RELAXED-NEXT:    ret void
//
void foo(int *x) {
  #pragma omp atomic update
    *x = *x + 1;
}
