/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerLogin;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class SQLServerLoginManager
extends SQLObjectEditor<SQLServerLogin, SQLServerDataSource>
implements DBEObjectRenamer<SQLServerLogin> {
    protected SQLServerLogin createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        return new SQLServerLogin((SQLServerDataSource)((Object)container), "new_login");
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) throws DBException {
        SQLServerLogin login = (SQLServerLogin)command.getObject();
        command.setDisableSessionLogging(true);
        StringBuilder script = new StringBuilder(64);
        script.append("CREATE LOGIN ").append(DBUtils.getQuotedIdentifier((DBPDataSource)login.getDataSource(), (String)login.getName()));
        if (CommonUtils.isNotEmpty((String)login.getPassword())) {
            script.append(" WITH PASSWORD =").append(SQLUtils.quoteString((DBPDataSource)login.getDataSource(), (String)login.getPassword()));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create login", script.toString()));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        SQLServerLogin login = (SQLServerLogin)command.getObject();
        if (command.hasProperty((Object)"disabled")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter login", "ALTER LOGIN " + DBUtils.getQuotedIdentifier((DBPDataSource)login.getDataSource(), (String)login.getName()) + (login.isDisabled() ? " DISABLE" : " ENABLE")));
        }
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop login", "DROP LOGIN " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject()))));
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, SQLServerLogin> getObjectsCache(SQLServerLogin object) {
        return object.getDataSource().getServerLoginCache();
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        SQLServerLogin login = (SQLServerLogin)command.getObject();
        SQLServerDataSource dataSource = login.getDataSource();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename login", "ALTER LOGIN " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + " WITH NAME = " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull SQLServerLogin object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }
}

