# Cross-Project Collaboration

Open source firmware has become popular and important over the last several
decades and is currently anchored in multiple key applications like industry,
automotive, infrastructure and commodity PC systems. coreboot has a
long-reaching history in all these applications and has become a vital
alternative to proprietary firmware solutions. Since coreboot itself is
minimalistic, other open source projects like SeaBIOS and flashrom help complete
the overall user experience by providing a well established way to boot into an
OS and easily reprogram the firmware on demand.

Open source projects often lack funds and are heavily dependent on volunteer
work by enthusiasts. coreboot has made its way over the many years it’s been
running and is now able to operate its own paid infrastructure for various
services like git, Gerrit and Jenkins, all of them are key factors for a
worldwide collaboration and project success. Other small but still important
projects do not have such resources and face infrastructure issues more often.

Furthermore, often the same people do work for different open source projects.
Therefore, it is important to support such projects where feasible.
For instance, sharing the IT infrastructure can leverage quite some synergies
as the tasks for different projects are quite similar, e.g. push code to public,
review it in Gerrit, let Jenkins do a build and report back to Gerrit or provide
a bug tracker platform where users and developers can report bugs and issues.
The coreboot project already has servers providing such services and these have
a huge amount of headroom to execute such tasks for other projects.
Additionally, the developers working on multiple projects are supported as they
can do their work with the same mindset while interfacing with common services
among different projects. This not only improves cross-project collaboration but
also does improve code quality because the developers do not have to switch
between different project setups.

Therefore, the coreboot project explicitly encourages collaboration with other
open source projects in the firmware domain. Especially the already well
established partnership with flashrom, SeaBIOS, and EM100 should continue to be
maintained further on. This includes:

* Sharing of the IT infrastructure
* Sharing the critical services like git, Gerrit, Jenkins and the bugtracker
* Sharing of the established communication methods via mailing list, Slack, IRC
  or Discord
* Sharing web services for web page or wikis and blog posts

If there is interest in a collaboration, please reach out to
coreboot@coreboot.org.

The coreboot project is still responsible and in charge of its offered services
to partner projects. The technical details of the collaboration will be
discussed on a case-by-case basis with affected parties where coreboot project
infrastructure maintainers have the lead.

Note that it is expected that everyone using the coreboot services is expected
to follow coreboot code-of-conduct policies at all times. In cases where the
coreboot CoC is broken by someone working only on other projects in the coreboot
infrastructure, the coreboot leadership will work with the leadership of the
other project on the issue.
