# Installation
> `npm install --save @types/react-window-infinite-loader`

# Summary
This package contains type definitions for react-window-infinite-loader (https://github.com/bvaughn/react-window-infinite-loader/).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-window-infinite-loader.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-window-infinite-loader/index.d.ts)
````ts
// Type definitions for react-window-infinite-loader 1.0
// Project: https://github.com/bvaughn/react-window-infinite-loader/
// Definitions by: Nivesh Ravindran <https://github.com/Nibblesh>
//                 fnknzzz <https://github.com/fnknzzz>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped
// TypeScript Version: 3.5

import { FC, Ref, ReactNode, Component } from 'react';
import { ListOnItemsRenderedProps, FixedSizeList, VariableSizeList } from 'react-window';

type OnItemsRendered = (props: ListOnItemsRenderedProps) => any;

interface InfiniteLoaderProps {
    isItemLoaded: (index: number) => boolean;
    loadMoreItems: (startIndex: number, stopIndex: number) => Promise<void> | void;
    itemCount: number;
    children: (props: { onItemsRendered: OnItemsRendered; ref: (ref: any) => void }) => ReactNode;
    threshold?: number | undefined;
    minimumBatchSize?: number | undefined;
}

declare class InfiniteLoader extends Component<InfiniteLoaderProps> {
    resetloadMoreItemsCache(autoReload?: boolean): void;
}

export = InfiniteLoader;

````

### Additional Details
 * Last updated: Tue, 01 Feb 2022 22:31:27 GMT
 * Dependencies: [@types/react](https://npmjs.com/package/@types/react), [@types/react-window](https://npmjs.com/package/@types/react-window)
 * Global values: none

# Credits
These definitions were written by [Nivesh Ravindran](https://github.com/Nibblesh), and [fnknzzz](https://github.com/fnknzzz).
