/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the DoCarrierLookupResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DoCarrierLookupResponse{}

// DoCarrierLookupResponse struct for DoCarrierLookupResponse
type DoCarrierLookupResponse struct {
	// The cost to check that one number is constant – 0.04 in your account currency.
	Cost float32 `json:"cost"`
	Country NullableCountry `json:"country,omitempty"`
	// Phone number in [National format](https://en.wikipedia.org/wiki/National_conventions_for_writing_telephone_numbers).
	Local string `json:"local"`
	// Phone number type.
	Type string `json:"type"`
	// Carrier name.
	Carrier string `json:"carrier"`
	// Phone number in [E.164 format](https://en.wikipedia.org/wiki/E.164).
	Number164 string `json:"number164"`
	// This field shows whether the entered phone number is valid or not.
	Valid bool `json:"valid"`
}

type _DoCarrierLookupResponse DoCarrierLookupResponse

// NewDoCarrierLookupResponse instantiates a new DoCarrierLookupResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDoCarrierLookupResponse(cost float32, local string, type_ string, carrier string, number164 string, valid bool) *DoCarrierLookupResponse {
	this := DoCarrierLookupResponse{}
	this.Cost = cost
	this.Local = local
	this.Type = type_
	this.Carrier = carrier
	this.Number164 = number164
	this.Valid = valid
	return &this
}

// NewDoCarrierLookupResponseWithDefaults instantiates a new DoCarrierLookupResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDoCarrierLookupResponseWithDefaults() *DoCarrierLookupResponse {
	this := DoCarrierLookupResponse{}
	return &this
}

// GetCost returns the Cost field value
func (o *DoCarrierLookupResponse) GetCost() float32 {
	if o == nil {
		var ret float32
		return ret
	}

	return o.Cost
}

// GetCostOk returns a tuple with the Cost field value
// and a boolean to check if the value has been set.
func (o *DoCarrierLookupResponse) GetCostOk() (*float32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Cost, true
}

// SetCost sets field value
func (o *DoCarrierLookupResponse) SetCost(v float32) {
	o.Cost = v
}

// GetCountry returns the Country field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DoCarrierLookupResponse) GetCountry() Country {
	if o == nil || IsNil(o.Country.Get()) {
		var ret Country
		return ret
	}
	return *o.Country.Get()
}

// GetCountryOk returns a tuple with the Country field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DoCarrierLookupResponse) GetCountryOk() (*Country, bool) {
	if o == nil {
		return nil, false
	}
	return o.Country.Get(), o.Country.IsSet()
}

// HasCountry returns a boolean if a field has been set.
func (o *DoCarrierLookupResponse) HasCountry() bool {
	if o != nil && o.Country.IsSet() {
		return true
	}

	return false
}

// SetCountry gets a reference to the given NullableCountry and assigns it to the Country field.
func (o *DoCarrierLookupResponse) SetCountry(v Country) {
	o.Country.Set(&v)
}
// SetCountryNil sets the value for Country to be an explicit nil
func (o *DoCarrierLookupResponse) SetCountryNil() {
	o.Country.Set(nil)
}

// UnsetCountry ensures that no value is present for Country, not even an explicit nil
func (o *DoCarrierLookupResponse) UnsetCountry() {
	o.Country.Unset()
}

// GetLocal returns the Local field value
func (o *DoCarrierLookupResponse) GetLocal() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Local
}

// GetLocalOk returns a tuple with the Local field value
// and a boolean to check if the value has been set.
func (o *DoCarrierLookupResponse) GetLocalOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Local, true
}

// SetLocal sets field value
func (o *DoCarrierLookupResponse) SetLocal(v string) {
	o.Local = v
}

// GetType returns the Type field value
func (o *DoCarrierLookupResponse) GetType() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Type
}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
func (o *DoCarrierLookupResponse) GetTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Type, true
}

// SetType sets field value
func (o *DoCarrierLookupResponse) SetType(v string) {
	o.Type = v
}

// GetCarrier returns the Carrier field value
func (o *DoCarrierLookupResponse) GetCarrier() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Carrier
}

// GetCarrierOk returns a tuple with the Carrier field value
// and a boolean to check if the value has been set.
func (o *DoCarrierLookupResponse) GetCarrierOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Carrier, true
}

// SetCarrier sets field value
func (o *DoCarrierLookupResponse) SetCarrier(v string) {
	o.Carrier = v
}

// GetNumber164 returns the Number164 field value
func (o *DoCarrierLookupResponse) GetNumber164() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Number164
}

// GetNumber164Ok returns a tuple with the Number164 field value
// and a boolean to check if the value has been set.
func (o *DoCarrierLookupResponse) GetNumber164Ok() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Number164, true
}

// SetNumber164 sets field value
func (o *DoCarrierLookupResponse) SetNumber164(v string) {
	o.Number164 = v
}

// GetValid returns the Valid field value
func (o *DoCarrierLookupResponse) GetValid() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.Valid
}

// GetValidOk returns a tuple with the Valid field value
// and a boolean to check if the value has been set.
func (o *DoCarrierLookupResponse) GetValidOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Valid, true
}

// SetValid sets field value
func (o *DoCarrierLookupResponse) SetValid(v bool) {
	o.Valid = v
}

func (o DoCarrierLookupResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DoCarrierLookupResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["cost"] = o.Cost
	if o.Country.IsSet() {
		toSerialize["country"] = o.Country.Get()
	}
	toSerialize["local"] = o.Local
	toSerialize["type"] = o.Type
	toSerialize["carrier"] = o.Carrier
	toSerialize["number164"] = o.Number164
	toSerialize["valid"] = o.Valid
	return toSerialize, nil
}

func (o *DoCarrierLookupResponse) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"cost",
		"local",
		"type",
		"carrier",
		"number164",
		"valid",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varDoCarrierLookupResponse := _DoCarrierLookupResponse{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varDoCarrierLookupResponse)

	if err != nil {
		return err
	}

	*o = DoCarrierLookupResponse(varDoCarrierLookupResponse)

	return err
}

type NullableDoCarrierLookupResponse struct {
	value *DoCarrierLookupResponse
	isSet bool
}

func (v NullableDoCarrierLookupResponse) Get() *DoCarrierLookupResponse {
	return v.value
}

func (v *NullableDoCarrierLookupResponse) Set(val *DoCarrierLookupResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableDoCarrierLookupResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableDoCarrierLookupResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDoCarrierLookupResponse(val *DoCarrierLookupResponse) *NullableDoCarrierLookupResponse {
	return &NullableDoCarrierLookupResponse{value: val, isSet: true}
}

func (v NullableDoCarrierLookupResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDoCarrierLookupResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


