// Code generated by smithy-go-codegen DO NOT EDIT.

package sns

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of phone numbers that are opted out, meaning you cannot send SMS
// messages to them.
//
// The results for ListPhoneNumbersOptedOut are paginated, and each page returns
// up to 100 phone numbers. If additional phone numbers are available after the
// first page of results, then a NextToken string will be returned. To receive the
// next page, you call ListPhoneNumbersOptedOut again using the NextToken string
// received from the previous call. When there are no more records to return,
// NextToken will be null.
func (c *Client) ListPhoneNumbersOptedOut(ctx context.Context, params *ListPhoneNumbersOptedOutInput, optFns ...func(*Options)) (*ListPhoneNumbersOptedOutOutput, error) {
	if params == nil {
		params = &ListPhoneNumbersOptedOutInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPhoneNumbersOptedOut", params, optFns, c.addOperationListPhoneNumbersOptedOutMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPhoneNumbersOptedOutOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The input for the ListPhoneNumbersOptedOut action.
type ListPhoneNumbersOptedOutInput struct {

	// A NextToken string is used when you call the ListPhoneNumbersOptedOut action to
	// retrieve additional records that are available after the first page of results.
	NextToken *string

	noSmithyDocumentSerde
}

// The response from the ListPhoneNumbersOptedOut action.
type ListPhoneNumbersOptedOutOutput struct {

	// A NextToken string is returned when you call the ListPhoneNumbersOptedOut
	// action if additional records are available after the first page of results.
	NextToken *string

	// A list of phone numbers that are opted out of receiving SMS messages. The list
	// is paginated, and each page can contain up to 100 phone numbers.
	PhoneNumbers []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPhoneNumbersOptedOutMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpListPhoneNumbersOptedOut{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpListPhoneNumbersOptedOut{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPhoneNumbersOptedOut"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPhoneNumbersOptedOut(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListPhoneNumbersOptedOutPaginatorOptions is the paginator options for
// ListPhoneNumbersOptedOut
type ListPhoneNumbersOptedOutPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPhoneNumbersOptedOutPaginator is a paginator for ListPhoneNumbersOptedOut
type ListPhoneNumbersOptedOutPaginator struct {
	options   ListPhoneNumbersOptedOutPaginatorOptions
	client    ListPhoneNumbersOptedOutAPIClient
	params    *ListPhoneNumbersOptedOutInput
	nextToken *string
	firstPage bool
}

// NewListPhoneNumbersOptedOutPaginator returns a new
// ListPhoneNumbersOptedOutPaginator
func NewListPhoneNumbersOptedOutPaginator(client ListPhoneNumbersOptedOutAPIClient, params *ListPhoneNumbersOptedOutInput, optFns ...func(*ListPhoneNumbersOptedOutPaginatorOptions)) *ListPhoneNumbersOptedOutPaginator {
	if params == nil {
		params = &ListPhoneNumbersOptedOutInput{}
	}

	options := ListPhoneNumbersOptedOutPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPhoneNumbersOptedOutPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPhoneNumbersOptedOutPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPhoneNumbersOptedOut page.
func (p *ListPhoneNumbersOptedOutPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPhoneNumbersOptedOutOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPhoneNumbersOptedOut(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPhoneNumbersOptedOutAPIClient is a client that implements the
// ListPhoneNumbersOptedOut operation.
type ListPhoneNumbersOptedOutAPIClient interface {
	ListPhoneNumbersOptedOut(context.Context, *ListPhoneNumbersOptedOutInput, ...func(*Options)) (*ListPhoneNumbersOptedOutOutput, error)
}

var _ ListPhoneNumbersOptedOutAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPhoneNumbersOptedOut(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPhoneNumbersOptedOut",
	}
}
