// Code generated by smithy-go-codegen DO NOT EDIT.

package ses

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ses/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Composes an email message and immediately queues it for sending. To send email
// using this operation, your message must meet the following requirements:
//
//   - The message must be sent from a verified email address or domain. If you
//     attempt to send email using a non-verified address or domain, the operation
//     results in an "Email address not verified" error.
//
//   - If your account is still in the Amazon SES sandbox, you may only send to
//     verified addresses or domains, or to email addresses associated with the Amazon
//     SES Mailbox Simulator. For more information, see [Verifying Email Addresses and Domains]in the Amazon SES Developer
//     Guide.
//
//   - The maximum message size is 10 MB.
//
//   - The message must include at least one recipient email address. The
//     recipient address can be a To: address, a CC: address, or a BCC: address. If a
//     recipient email address is invalid (that is, it is not in the format
//     UserName@[SubDomain.]Domain.TopLevelDomain), the entire message is rejected,
//     even if the message contains other recipients that are valid.
//
//   - The message may not include more than 50 recipients, across the To:, CC:
//     and BCC: fields. If you need to send an email message to a larger audience, you
//     can divide your recipient list into groups of 50 or fewer, and then call the
//     SendEmail operation several times to send the message to each group.
//
// For every message that you send, the total number of recipients (including each
// recipient in the To:, CC: and BCC: fields) is counted against the maximum number
// of emails you can send in a 24-hour period (your sending quota). For more
// information about sending quotas in Amazon SES, see [Managing Your Amazon SES Sending Limits]in the Amazon SES Developer
// Guide.
//
// [Verifying Email Addresses and Domains]: https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html
// [Managing Your Amazon SES Sending Limits]: https://docs.aws.amazon.com/ses/latest/dg/manage-sending-quotas.html
func (c *Client) SendEmail(ctx context.Context, params *SendEmailInput, optFns ...func(*Options)) (*SendEmailOutput, error) {
	if params == nil {
		params = &SendEmailInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SendEmail", params, optFns, c.addOperationSendEmailMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SendEmailOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents a request to send a single formatted email using Amazon SES. For
// more information, see the [Amazon SES Developer Guide].
//
// [Amazon SES Developer Guide]: https://docs.aws.amazon.com/ses/latest/dg/send-email-formatted.html
type SendEmailInput struct {

	// The destination for this email, composed of To:, CC:, and BCC: fields.
	//
	// This member is required.
	Destination *types.Destination

	// The message to be sent.
	//
	// This member is required.
	Message *types.Message

	// The email address that is sending the email. This email address must be either
	// individually verified with Amazon SES, or from a domain that has been verified
	// with Amazon SES. For information about verifying identities, see the [Amazon SES Developer Guide].
	//
	// If you are sending on behalf of another user and have been permitted to do so
	// by a sending authorization policy, then you must also specify the SourceArn
	// parameter. For more information about sending authorization, see the [Amazon SES Developer Guide].
	//
	// Amazon SES does not support the SMTPUTF8 extension, as described in [RFC6531]. For this
	// reason, the email address string must be 7-bit ASCII. If you want to send to or
	// from email addresses that contain Unicode characters in the domain part of an
	// address, you must encode the domain using Punycode. Punycode is not permitted in
	// the local part of the email address (the part before the @ sign) nor in the
	// "friendly from" name. If you want to use Unicode characters in the "friendly
	// from" name, you must encode the "friendly from" name using MIME encoded-word
	// syntax, as described in [Sending raw email using the Amazon SES API]. For more information about Punycode, see [RFC 3492].
	//
	// [RFC6531]: https://tools.ietf.org/html/rfc6531
	// [Amazon SES Developer Guide]: https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html
	// [Sending raw email using the Amazon SES API]: https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html
	// [RFC 3492]: http://tools.ietf.org/html/rfc3492
	//
	// This member is required.
	Source *string

	// The name of the configuration set to use when you send an email using SendEmail .
	ConfigurationSetName *string

	// The reply-to email address(es) for the message. If the recipient replies to the
	// message, each reply-to address receives the reply.
	ReplyToAddresses []string

	// The email address that bounces and complaints are forwarded to when feedback
	// forwarding is enabled. If the message cannot be delivered to the recipient, then
	// an error message is returned from the recipient's ISP; this message is forwarded
	// to the email address specified by the ReturnPath parameter. The ReturnPath
	// parameter is never overwritten. This email address must be either individually
	// verified with Amazon SES, or from a domain that has been verified with Amazon
	// SES.
	ReturnPath *string

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the ReturnPath parameter.
	//
	// For example, if the owner of example.com (which has ARN
	// arn:aws:ses:us-east-1:123456789012:identity/example.com ) attaches a policy to
	// it that authorizes you to use feedback@example.com , then you would specify the
	// ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com ,
	// and the ReturnPath to be feedback@example.com .
	//
	// For more information about sending authorization, see the [Amazon SES Developer Guide].
	//
	// [Amazon SES Developer Guide]: https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html
	ReturnPathArn *string

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to send for the email address specified in the Source parameter.
	//
	// For example, if the owner of example.com (which has ARN
	// arn:aws:ses:us-east-1:123456789012:identity/example.com ) attaches a policy to
	// it that authorizes you to send from user@example.com , then you would specify
	// the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com ,
	// and the Source to be user@example.com .
	//
	// For more information about sending authorization, see the [Amazon SES Developer Guide].
	//
	// [Amazon SES Developer Guide]: https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html
	SourceArn *string

	// A list of tags, in the form of name/value pairs, to apply to an email that you
	// send using SendEmail . Tags correspond to characteristics of the email that you
	// define, so that you can publish email sending events.
	Tags []types.MessageTag

	noSmithyDocumentSerde
}

// Represents a unique message ID.
type SendEmailOutput struct {

	// The unique message identifier returned from the SendEmail action.
	//
	// This member is required.
	MessageId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSendEmailMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpSendEmail{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpSendEmail{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SendEmail"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSendEmailValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSendEmail(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSendEmail(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SendEmail",
	}
}
