from sickle.common.lib.reversing import smartarch

def get_linux_syscalls(syscall_list):

    syscall_table = {}

    syscalls = {
        "aarch64" : {
            "io_setup"	             : 0x00, 
            "io_destroy"	         : 0x01,
            "io_submit"	             : 0x02,
            "io_cancel"	             : 0x03,
            "io_getevents"	         : 0x04,
            "setxattr"	             : 0x05,
            "lsetxattr"	             : 0x06,
            "fsetxattr"	             : 0x07,
            "getxattr"	             : 0x08,
            "lgetxattr"	             : 0x09,
            "fgetxattr"	             : 0x0a,
            "listxattr"	             : 0x0b,
            "llistxattr"	         : 0x0c,
            "flistxattr"	         : 0x0d,
            "removexattr"	         : 0x0e,
            "lremovexattr"	         : 0x0f,
            "fremovexattr"	         : 0x10,
            "getcwd"	             : 0x11,
            "lookup_dcookie"	     : 0x12,
            "eventfd2"	             : 0x13,
            "epoll_create1"	         : 0x14,
            "epoll_ctl"	             : 0x15,
            "epoll_pwait"	         : 0x16,
            "dup"	                 : 0x17,
            "dup3"	                 : 0x18,
            "fcntl"	                 : 0x19,
            "inotify_init1"	         : 0x1a,
            "inotify_add_watch"	     : 0x1b,
            "inotify_rm_watch"	     : 0x1c,
            "ioctl"	                 : 0x1d,
            "ioprio_set"	         : 0x1e,
            "ioprio_get"	         : 0x1f,
            "flock"	                 : 0x20,
            "mknodat"	             : 0x21,
            "mkdirat"	             : 0x22,
            "unlinkat"	             : 0x23,
            "symlinkat"	             : 0x24,
            "linkat"	             : 0x25,
            "renameat"	             : 0x26,
            "umount2"	             : 0x27,
            "mount"	                 : 0x28,
            "pivot_root"	         : 0x29,
            "nfsservctl"	         : 0x2a,
            "statfs"	             : 0x2b,
            "fstatfs"	             : 0x2c,
            "truncate"	             : 0x2d,
            "ftruncate"	             : 0x2e,
            "fallocate"	             : 0x2f,
            "faccessat"	             : 0x30,
            "chdir"	                 : 0x31,
            "fchdir"	             : 0x32,
            "chroot"	             : 0x33,
            "fchmod"	             : 0x34,
            "fchmodat"	             : 0x35,
            "fchownat"	             : 0x36,
            "fchown"	             : 0x37,
            "openat"	             : 0x38,
            "close"	                 : 0x39,
            "vhangup"	             : 0x3a,
            "pipe2"	                 : 0x3b,
            "quotactl"	             : 0x3c,
            "getdents64"	         : 0x3d,
            "lseek"	                 : 0x3e,
            "read"	                 : 0x3f,
            "write"	                 : 0x40,
            "readv"	                 : 0x41,
            "writev"	             : 0x42,
            "pread64"	             : 0x43,
            "pwrite64"	             : 0x44,
            "preadv"	             : 0x45,
            "pwritev"	             : 0x46,
            "sendfile"	             : 0x47,
            "pselect6"	             : 0x48,
            "ppoll"	                 : 0x49,
            "signalfd4"	             : 0x4a,
            "vmsplice"	             : 0x4b,
            "splice"	             : 0x4c,
            "tee"	                 : 0x4d,
            "readlinkat"	         : 0x4e,
            "newfstatat"	         : 0x4f,
            "fstat"	                 : 0x50,
            "sync"	                 : 0x51,
            "fsync"	                 : 0x52,
            "fdatasync"	             : 0x53,
            "sync_file_range"	     : 0x54,
            "timerfd_create"	     : 0x55,
            "timerfd_settime"	     : 0x56,
            "timerfd_gettime"	     : 0x57,
            "utimensat"	             : 0x58,
            "acct"	                 : 0x59,
            "capget"	             : 0x5a,
            "capset"	             : 0x5b,
            "personality"	         : 0x5c,
            "exit"	                 : 0x5d,
            "exit_group"	         : 0x5e,
            "waitid"	             : 0x5f,
            "set_tid_address"	     : 0x60,
            "unshare"	             : 0x61,
            "futex"	                 : 0x62,
            "set_robust_list"	     : 0x63,
            "get_robust_list"	     : 0x64,
            "nanosleep"	             : 0x65,
            "getitimer"	             : 0x66,
            "setitimer"	             : 0x67,
            "kexec_load"	         : 0x68,
            "init_module"	         : 0x69,
            "delete_module"	         : 0x6a,
            "timer_create"	         : 0x6b,
            "timer_gettime"	         : 0x6c,
            "timer_getoverrun"	     : 0x6d,
            "timer_settime"	         : 0x6e,
            "timer_delete"	         : 0x6f,
            "clock_settime"	         : 0x70,
            "clock_gettime"	         : 0x71,
            "clock_getres"	         : 0x72,
            "clock_nanosleep"	     : 0x73,
            "syslog"	             : 0x74,
            "ptrace"	             : 0x75,
            "sched_setparam"	     : 0x76,
            "sched_setscheduler"	 : 0x77,
            "sched_getscheduler"	 : 0x78,
            "sched_getparam"	     : 0x79,
            "sched_setaffinity"	     : 0x7a,
            "sched_getaffinity"	     : 0x7b,
            "sched_yield"	         : 0x7c,
            "sched_get_priority_max" : 0x7d,
            "sched_get_priority_min" : 0x7e,
            "sched_rr_get_interval"	 : 0x7f,
            "restart_syscall"	     : 0x80,
            "kill"	                 : 0x81,
            "tkill"	                 : 0x82,
            "tgkill"	             : 0x83,
            "sigaltstack"	         : 0x84,
            "rt_sigsuspend"	         : 0x85,
            "rt_sigaction"	         : 0x86,
            "rt_sigprocmask"	     : 0x87,
            "rt_sigpending"	         : 0x88,
            "rt_sigtimedwait"	     : 0x89,
            "rt_sigqueueinfo"	     : 0x8a,
            "rt_sigreturn"	         : 0x8b,
            "setpriority"	         : 0x8c,
            "getpriority"	         : 0x8d,
            "reboot"	             : 0x8e,
            "setregid"	             : 0x8f,
            "setgid"	             : 0x90,
            "setreuid"	             : 0x91,
            "setuid"	             : 0x92,
            "setresuid"	             : 0x93,
            "getresuid"	             : 0x94,
            "setresgid"	             : 0x95,
            "getresgid"	             : 0x96,
            "setfsuid"	             : 0x97,
            "setfsgid"	             : 0x98,
            "times"	                 : 0x99,
            "setpgid"	             : 0x9a,
            "getpgid"	             : 0x9b,
            "getsid"	             : 0x9c,
            "setsid"	             : 0x9d,
            "getgroups"	             : 0x9e,
            "setgroups"	             : 0x9f,
            "uname"	                 : 0xa0,
            "sethostname"	         : 0xa1,
            "setdomainname"	         : 0xa2,
            "getrlimit"	             : 0xa3,
            "setrlimit"	             : 0xa4,
            "getrusage"	             : 0xa5,
            "umask"	                 : 0xa6,
            "prctl"	                 : 0xa7,
            "getcpu"	             : 0xa8,
            "gettimeofday"	         : 0xa9,
            "settimeofday"	         : 0xaa,
            "adjtimex"	             : 0xab,
            "getpid"	             : 0xac,
            "getppid"	             : 0xad,
            "getuid"	             : 0xae,
            "geteuid"	             : 0xaf,
            "getgid"	             : 0xb0,
            "getegid"	             : 0xb1,
            "gettid"	             : 0xb2,
            "sysinfo"	             : 0xb3,
            "mq_open"	             : 0xb4,
            "mq_unlink"	             : 0xb5,
            "mq_timedsend"	         : 0xb6,
            "mq_timedreceive"	     : 0xb7,
            "mq_notify"	             : 0xb8,
            "mq_getsetattr"	         : 0xb9,
            "msgget"	             : 0xba,
            "msgctl"	             : 0xbb,
            "msgrcv"	             : 0xbc,
            "msgsnd"	             : 0xbd,
            "semget"	             : 0xbe,
            "semctl"	             : 0xbf,
            "semtimedop"	         : 0xc0,
            "semop"	                 : 0xc1,
            "shmget"	             : 0xc2,
            "shmctl"	             : 0xc3,
            "shmat"	                 : 0xc4,
            "shmdt"	                 : 0xc5,
            "socket"	             : 0xc6,
            "socketpair"	         : 0xc7,
            "bind"	                 : 0xc8,
            "listen"	             : 0xc9,
            "accept"	             : 0xca,
            "connect"	             : 0xcb,
            "getsockname"	         : 0xcc,
            "getpeername"	         : 0xcd,
            "sendto"	             : 0xce,
            "recvfrom"	             : 0xcf,
            "setsockopt"	         : 0xd0,
            "getsockopt"	         : 0xd1,
            "shutdown"	             : 0xd2,
            "sendmsg"	             : 0xd3,
            "recvmsg"	             : 0xd4,
            "readahead"	             : 0xd5,
            "brk"	                 : 0xd6,
            "munmap"	             : 0xd7,
            "mremap"	             : 0xd8,
            "add_key"	             : 0xd9,
            "request_key"	         : 0xda,
            "keyctl"	             : 0xdb,
            "clone"	                 : 0xdc,
            "execve"	             : 0xdd,
            "mmap"	                 : 0xde,
            "fadvise64"	             : 0xdf,
            "swapon"	             : 0xe0,
            "swapoff"	             : 0xe1,
            "mprotect"	             : 0xe2,
            "msync"	                 : 0xe3,
            "mlock"	                 : 0xe4,
            "munlock"	             : 0xe5,
            "mlockall"	             : 0xe6,
            "munlockall"	         : 0xe7,
            "mincore"	             : 0xe8,
            "madvise"	             : 0xe9,
            "remap_file_pages"	     : 0xea,
            "mbind"	                 : 0xeb,
            "get_mempolicy"	         : 0xec,
            "set_mempolicy"	         : 0xed,
            "migrate_pages"	         : 0xee,
            "move_pages"	         : 0xef,
            "rt_tgsigqueueinfo"	     : 0xf0,
            "perf_event_open"	     : 0xf1,
            "accept4"	             : 0xf2,
            "recvmmsg"	             : 0xf3,
            "wait4"	                 : 0x104, 
            "prlimit64"	             : 0x105,
            "fanotify_init"	         : 0x106,
            "fanotify_mark"	         : 0x107,
            "name_to_handle_at"	     : 0x108,
            "open_by_handle_at"	     : 0x109,
            "clock_adjtime"	         : 0x10a,
            "syncfs"	             : 0x10b,
            "setns"	                 : 0x10c,
            "sendmmsg"	             : 0x10d,
            "process_vm_readv"	     : 0x10e,
            "process_vm_writev"	     : 0x10f,
            "kcmp"	                 : 0x110,
            "finit_module"	         : 0x111,
            "sched_setattr"	         : 0x112,
            "sched_getattr"	         : 0x113,
            "renameat2"	             : 0x114,
            "seccomp"	             : 0x115,
            "getrandom"	             : 0x116,
            "memfd_create"	         : 0x117,
            "bpf"	                 : 0x118,
            "execveat"	             : 0x119,
            "userfaultfd"	         : 0x11a,
            "membarrier"	         : 0x11b,
            "mlock2"	             : 0x11c,
            "copy_file_range"	     : 0x11d,
            "preadv2"	             : 0x11e,
            "pwritev2"	             : 0x11f,
            "pkey_mprotect"	         : 0x120,
            "pkey_alloc"	         : 0x121,
            "pkey_free"	             : 0x122,
            "statx"	                 : 0x123,

        },
        "x86" : {
            "restart_syscall"	     : 0x00, 
            "exit"	                 : 0x01,
            "fork"	                 : 0x02,
            "read"	                 : 0x03,
            "write"	                 : 0x04,
            "open"	                 : 0x05,
            "close"	                 : 0x06,
            "waitpid"	             : 0x07,
            "creat"	                 : 0x08,
            "link"	                 : 0x09,
            "unlink"	             : 0x0a,
            "execve"	             : 0x0b,
            "chdir"	                 : 0x0c,
            "time"	                 : 0x0d,
            "mknod"	                 : 0x0e,
            "chmod"	                 : 0x0f,
            "lchown"	             : 0x10,
            "break"	                 : 0x11,
            "oldstat"	             : 0x12,
            "lseek"	                 : 0x13,
            "getpid"	             : 0x14,
            "mount"	                 : 0x15,
            "umount"	             : 0x16,	
            "setuid"	             : 0x17,	
            "getuid"	             : 0x18,	
            "stime"	                 : 0x19,	
            "ptrace"	             : 0x1a,	
            "alarm"	                 : 0x1b,
            "oldfstat"	             : 0x1c,
            "pause"	                 : 0x1d,
            "utime"	                 : 0x1e,
            "stty"	                 : 0x1f,
            "gtty"	                 : 0x20,
            "access"	             : 0x21,
            "nice"	                 : 0x22,
            "ftime"	                 : 0x23,
            "sync"	                 : 0x24,
            "kill"	                 : 0x25,
            "rename"	             : 0x26,
            "mkdir"	                 : 0x27,
            "rmdir"	                 : 0x28,
            "dup"	                 : 0x29,
            "pipe"	                 : 0x2a,
            "times"	                 : 0x2b,
            "prof"	                 : 0x2c,
            "brk"	                 : 0x2d,
            "setgid"	             : 0x2e,
            "getgid"	             : 0x2f,
            "signal"	             : 0x30,
            "geteuid"	             : 0x31,
            "getegid"	             : 0x32,
            "acct"	                 : 0x33,
            "umount2"	             : 0x34,
            "lock"	                 : 0x35,
            "ioctl"	                 : 0x36,
            "fcntl"	                 : 0x37,
            "mpx"	                 : 0x38,
            "setpgid"	             : 0x39,
            "ulimit"	             : 0x3a,
            "oldolduname"	         : 0x3b,
            "umask"	                 : 0x3c,
            "chroot"	             : 0x3d,
            "ustat"	                 : 0x3e,
            "dup2"	                 : 0x3f,
            "getppid"	             : 0x40,
            "getpgrp"	             : 0x41,
            "setsid"	             : 0x42,
            "sigaction"	             : 0x43,
            "sgetmask"	             : 0x44,
            "ssetmask"	             : 0x45,
            "setreuid"	             : 0x46,
            "setregid"	             : 0x47,
            "sigsuspend"	         : 0x48,
            "sigpending"	         : 0x49,
            "sethostname"	         : 0x4a,
            "setrlimit"	             : 0x4b,
            "getrlimit"	             : 0x4c,
            "getrusage"	             : 0x4d,
            "gettimeofday"	         : 0x4e,
            "settimeofday"	         : 0x4f,
            "getgroups"	             : 0x50,
            "setgroups"	             : 0x51,
            "select"	             : 0x52,
            "symlink"	             : 0x53,
            "oldlstat"	             : 0x54,
            "readlink"	             : 0x55,
            "uselib"	             : 0x56,
            "swapon"	             : 0x57,
            "reboot"	             : 0x58,
            "readdir"	             : 0x59,
            "mmap"	                 : 0x5a,
            "munmap"	             : 0x5b,
            "truncate"	             : 0x5c,
            "ftruncate"	             : 0x5d,
            "fchmod"	             : 0x5e,
            "fchown"	             : 0x5f,
            "getpriority"	         : 0x60,
            "setpriority"	         : 0x61,
            "profil"	             : 0x62,
            "statfs"	             : 0x63,
            "fstatfs"	             : 0x64,
            "ioperm"	             : 0x65,
            "socketcall"	         : 0x66,
            "syslog"	             : 0x67,
            "setitimer"	             : 0x68,
            "getitimer"	             : 0x69,
            "stat"	                 : 0x6a,
            "lstat"	                 : 0x6b,
            "fstat"	                 : 0x6c,
            "olduname"	             : 0x6d,
            "iopl"	                 : 0x6e,
            "vhangup"	             : 0x6f,
            "idle"	                 : 0x70,
            "vm86old"	             : 0x71,
            "wait4"	                 : 0x72,
            "swapoff"	             : 0x73,
            "sysinfo"	             : 0x74,
            "ipc"	                 : 0x75,
            "fsync"	                 : 0x76,
            "sigreturn"	             : 0x77,
            "clone"	                 : 0x78,
            "setdomainname"	         : 0x79,
            "uname"	                 : 0x7a,
            "modify_ldt"	         : 0x7b,
            "adjtimex"	             : 0x7c,
            "mprotect"	             : 0x7d,
            "sigprocmask"	         : 0x7e,
            "create_module"	         : 0x7f,
            "init_module"	         : 0x80,
            "delete_module"	         : 0x81,
            "get_kernel_syms"	     : 0x82,
            "quotactl"	             : 0x83,
            "getpgid"	             : 0x84,
            "fchdir"	             : 0x85,
            "bdflush"	             : 0x86,
            "sysfs"	                 : 0x87,
            "personality"	         : 0x88,
            "afs_syscall"	         : 0x89,
            "setfsuid"	             : 0x8a,
            "setfsgid"	             : 0x8b,
            "_llseek"	             : 0x8c,
            "getdents"	             : 0x8d,
            "_newselect"	         : 0x8e,
            "flock"	                 : 0x8f,
            "msync"	                 : 0x90,
            "readv"	                 : 0x91,
            "writev"	             : 0x92,
            "getsid"	             : 0x93,
            "fdatasync"	             : 0x94,
            "_sysctl"	             : 0x95,
            "mlock"	                 : 0x96,
            "munlock"	             : 0x97,
            "mlockall"	             : 0x98,
            "munlockall"	         : 0x99,
            "sched_setparam"	     : 0x9a,
            "sched_getparam"	     : 0x9b,
            "sched_setscheduler"	 : 0x9c,
            "sched_getscheduler"	 : 0x9d,
            "sched_yield"	         : 0x9e,
            "sched_get_priority_max" : 0x9f,
            "sched_get_priority_min" : 0xa0,
            "sched_rr_get_interval"	 : 0xa1,
            "nanosleep"	             : 0xa2,
            "mremap"	             : 0xa3,
            "setresuid"	             : 0xa4,
            "getresuid"	             : 0xa5,
            "vm86"	                 : 0xa6,
            "query_module"	         : 0xa7,
            "poll"	                 : 0xa8,
            "nfsservctl"	         : 0xa9,
            "setresgid"	             : 0xaa,
            "getresgid"	             : 0xab,
            "prctl"	                 : 0xac,
            "rt_sigreturn"	         : 0xad,
            "rt_sigaction"	         : 0xae,
            "rt_sigprocmask"	     : 0xaf,
            "rt_sigpending"	         : 0xb0,
            "rt_sigtimedwait"	     : 0xb1,
            "rt_sigqueueinfo"	     : 0xb2,
            "rt_sigsuspend"	         : 0xb3,
            "pread64"	             : 0xb4,
            "pwrite64"    	         : 0xb5,
            "chown"	                 : 0xb6,
            "getcwd"	             : 0xb7,
            "capget"	             : 0xb8,
            "capset"	             : 0xb9,
            "sigaltstack"	         : 0xba,
            "sendfile"	             : 0xbb,
            "getpmsg"	             : 0xbc,
            "putpmsg"	             : 0xbd,
            "vfork"	                 : 0xbe,
            "ugetrlimit"	         : 0xbf,
            "mmap2"	                 : 0xc0,
            "truncate64"	         : 0xc1,
            "ftruncate64"	         : 0xc2,
            "stat64"	             : 0xc3,
            "lstat64"	             : 0xc4,
            "fstat64"	             : 0xc5,
            "lchown32"	             : 0xc6,
            "getuid32"	             : 0xc7,
            "getgid32"	             : 0xc8,
            "geteuid32"	             : 0xc9,
            "getegid32"	             : 0xca,
            "setreuid32"	         : 0xcb,
            "setregid32"	         : 0xcc,
            "getgroups32"	         : 0xcd,
            "setgroups32"	         : 0xce,
            "fchown32"	             : 0xcf,
            "setresuid32"	         : 0xd0,
            "getresuid32"	         : 0xd1,
            "setresgid32"	         : 0xd2,
            "getresgid32"	         : 0xd3,
            "chown32"	             : 0xd4,
            "setuid32"	             : 0xd5,
            "setgid32"	             : 0xd6,
            "setfsuid32"	         : 0xd7,
            "setfsgid32"	         : 0xd8,
            "pivot_root"	         : 0xd9,
            "mincore"	             : 0xda,
            "madvise"	             : 0xdb,
            "getdents64"	         : 0xdc,
            "fcntl64"	             : 0xdd,
            "gettid"	             : 0xe0,
            "readahead"	             : 0xe1,
            "setxattr"	             : 0xe2,
            "lsetxattr"	             : 0xe3,
            "fsetxattr"	             : 0xe4,
            "getxattr"	             : 0xe5,
            "lgetxattr"	             : 0xe6,
            "fgetxattr"	             : 0xe7,
            "listxattr"	             : 0xe8,
            "llistxattr"	         : 0xe9,
            "flistxattr"	         : 0xea,
            "removexattr"	         : 0xeb,
            "lremovexattr"	         : 0xec,
            "fremovexattr"	         : 0xed,
            "tkill"	                 : 0xee,
            "sendfile64"	         : 0xef,
            "futex"	                 : 0xf0,
            "sched_setaffinity"	     : 0xf1,
            "sched_getaffinity"	     : 0xf2,
            "set_thread_area"	     : 0xf3,
            "get_thread_area"	     : 0xf4,
            "io_setup"	             : 0xf5,
            "io_destroy"	         : 0xf6,
            "io_getevents"	         : 0xf7,
            "io_submit"	             : 0xf8,	
            "io_cancel"	             : 0xf9,	
            "fadvise64"	             : 0xfa,	
            "exit_group"	         : 0xfc,	
            "lookup_dcookie"	     : 0xfd,	
            "epoll_create"	         : 0xfe,	
            "epoll_ctl"	             : 0xff,	
            "epoll_wait"	         : 0x100,	
            "remap_file_pages"	     : 0x101,	
            "set_tid_address"	     : 0x102,	
            "timer_create"	         : 0x103,	
            "timer_settime"	         : 0x104,	
            "timer_gettime"	         : 0x105,
            "timer_getoverrun"	     : 0x106,
            "timer_delete"	         : 0x107,
            "clock_settime"	         : 0x108,
            "clock_gettime"	         : 0x109,
            "clock_getres"	         : 0x10a,
            "clock_nanosleep"	     : 0x10b,
            "statfs64"	             : 0x10c,
            "fstatfs64"	             : 0x10d,
            "tgkill"	             : 0x10e,
            "utimes"	             : 0x10f,
            "fadvise64_64"	         : 0x110,
            "vserver"	             : 0x111,
            "mbind"	                 : 0x112,
            "get_mempolicy"	         : 0x113,
            "set_mempolicy"	         : 0x114,
            "mq_open"	             : 0x115,
            "mq_unlink"	             : 0x116,
            "mq_timedsend"	         : 0x117,
            "mq_timedreceive"	     : 0x118,
            "mq_notify"	             : 0x119,
            "mq_getsetattr"	         : 0x11a,
            "kexec_load"	         : 0x11b,
            "waitid"	             : 0x11c,
            "add_key"	             : 0x11e,
            "request_key"	         : 0x11f,
            "keyctl"	             : 0x120,
            "ioprio_set"	         : 0x121,
            "ioprio_get"	         : 0x122,
            "inotify_init"	         : 0x123,
            "inotify_add_watch"	     : 0x124,
            "inotify_rm_watch"	     : 0x125,
            "migrate_pages"	         : 0x126,
            "openat"	             : 0x127,
            "mkdirat"	             : 0x128,
            "mknodat"	             : 0x129,
            "fchownat"	             : 0x12a,
            "futimesat"	             : 0x12b,
            "fstatat64"	             : 0x12c,
            "unlinkat"	             : 0x12d,
            "renameat"	             : 0x12e,
            "linkat"	             : 0x12f,
            "symlinkat"	             : 0x130,
            "readlinkat"	         : 0x131,
            "fchmodat"	             : 0x132,
            "faccessat"	             : 0x133,
            "pselect6"	             : 0x134,
            "ppoll"	                 : 0x135,
            "unshare"	             : 0x136,
            "set_robust_list"	     : 0x137,
            "get_robust_list"	     : 0x138,
            "splice"	             : 0x139,
            "sync_file_range"	     : 0x13a,
            "tee"	                 : 0x13b,
            "vmsplice"	             : 0x13c,
            "move_pages"	         : 0x13d,
            "getcpu"	             : 0x13e,
            "epoll_pwait"	         : 0x13f,
            "utimensat"	             : 0x140,
            "signalfd"	             : 0x141,
            "timerfd_create"	     : 0x142,
            "eventfd"	             : 0x143,
            "fallocate"	             : 0x144,
            "timerfd_settime"	     : 0x145,
            "timerfd_gettime"	     : 0x146,
            "signalfd4"	             : 0x147,
            "eventfd2"	             : 0x148,
            "epoll_create1"	         : 0x149,
            "dup3"	                 : 0x14a,
            "pipe2"	                 : 0x14b,
            "inotify_init1"	         : 0x14c,
            "preadv"	             : 0x14d,
            "pwritev"	             : 0x14e,
            "rt_tgsigqueueinfo"	     : 0x14f,
            "perf_event_open"	     : 0x150,
            "recvmmsg"	             : 0x151,
            "fanotify_init"	         : 0x152,
            "fanotify_mark"	         : 0x153,
            "prlimit64"	             : 0x154,
            "name_to_handle_at"	     : 0x155,
            "open_by_handle_at"	     : 0x156,
            "clock_adjtime"	         : 0x157,
            "syncfs"	             : 0x158,
            "sendmmsg"	             : 0x159,
            "setns"	                 : 0x15a,
            "process_vm_readv"	     : 0x15b,
            "process_vm_writev"	     : 0x15c,
            "kcmp"	                 : 0x15d,
            "finit_module"	         : 0x15e,
            "sched_setattr"	         : 0x15f,
            "sched_getattr"	         : 0x160,
            "renameat2"	             : 0x161,
            "seccomp"	             : 0x162,
            "getrandom"	             : 0x163,
            "memfd_create"	         : 0x164,
            "bpf"	                 : 0x165,
            "execveat"	             : 0x166,
            "socket"	             : 0x167,
            "socketpair"	         : 0x168,
            "bind"	                 : 0x169,
            "connect"	             : 0x16a,
            "listen"	             : 0x16b,
            "accept4"	             : 0x16c,
            "getsockopt"	         : 0x16d,
            "setsockopt"	         : 0x16e,
            "getsockname"	         : 0x16f,
            "getpeername"	         : 0x170,
            "sendto"	             : 0x171,
            "sendmsg"	             : 0x172,
            "recvfrom"	             : 0x173,
            "recvmsg"	             : 0x174,
            "shutdown"	             : 0x175,
            "userfaultfd"	         : 0x176,
            "membarrier"	         : 0x177,
            "mlock2"	             : 0x178,
            "copy_file_range"	     : 0x179,
            "preadv2"	             : 0x17a,
            "pwritev2"	             : 0x17b,
            "pkey_mprotect"	         : 0x17c,
            "pkey_alloc"	         : 0x17d,
            "pkey_free"	             : 0x17e,
            "statx"	                 : 0x17f,
            "arch_prctl"	         : 0x180,

        },
        "x64" : {
            "read"                    : 0x00,	
            "write"                   : 0x01,	
            "open"                    : 0x02,	
            "close"                   : 0x03,	
            "stat"                    : 0x04,	
            "fstat"                   : 0x05,	
            "lstat"                   : 0x06,	
            "poll"                    : 0x07,	
            "lseek"                   : 0x08,	
            "mmap"                    : 0x09,	
            "mprotect"                : 0x0a,	
            "munmap"                  : 0x0b,	
            "brk"                     : 0x0c,	
            "rt_sigaction"            : 0x0d,	
            "rt_sigprocmask"	      : 0x0e,	
            "rt_sigreturn"	          : 0x0f,	
            "ioctl"	                  : 0x10,	
            "pread64"	              : 0x11,	
            "pwrite64"	              : 0x12,	
            "readv"	                  : 0x13,	
            "writev"	              : 0x14,	
            "access"	              : 0x15,	
            "pipe"	                  : 0x16,	
            "select"	              : 0x17,	
            "sched_yield"             : 0x18,	
            "mremap"	              : 0x19,
            "msync"	                  : 0x1a,	
            "mincore"	              : 0x1b,	
            "madvise"	              : 0x1c,	
            "shmget"	              : 0x1d,	
            "shmat"	                  : 0x1e,	
            "shmctl"	              : 0x1f,	
            "dup"                     : 0x20,	
            "dup2"	                  : 0x21,	
            "pause"	                  : 0x22,	
            "nanosleep"	              : 0x23,	
            "getitimer"	              : 0x24,	
            "alarm"	                  : 0x25,	
            "setitimer"	              : 0x26,	
            "getpid"	              : 0x27,	
            "sendfile"	              : 0x28,	
            "socket"	              : 0x29,	
            "connect"	              : 0x2a,	
            "accept"	              : 0x2b,	
            "sendto"	              : 0x2c,	
            "recvfrom"	              : 0x2d,	
            "sendmsg"	              : 0x2e,	
            "recvmsg"	              : 0x2f,	
            "shutdown"	              : 0x30,	
            "bind"	                  : 0x31,	
            "listen"	              : 0x32,	
            "getsockname"	          : 0x33,	
            "getpeername"	          : 0x34,	
            "socketpair"	          : 0x35,	
            "setsockopt"	          : 0x36,	
            "getsockopt"	          : 0x37,	
            "clone"	                  : 0x38,	
            "fork"	                  : 0x39,	
            "vfork"	                  : 0x3a,	
            "execve"	              : 0x3b,	
            "exit"	                  : 0x3c,	
            "wait4"	                  : 0x3d,	
            "kill"	                  : 0x3e,	
            "uname"	                  : 0x3f,	
            "semget"	              : 0x40,	
            "semop"	                  : 0x41,	
            "semctl"	              : 0x42,	
            "shmdt"	                  : 0x43,	
            "msgget"	              : 0x44,	
            "msgsnd"	              : 0x45,	
            "msgrcv"	              : 0x46,	
            "msgctl"	              : 0x47,	
            "fcntl"	                  : 0x48,	
            "flock"	                  : 0x49,	
            "fsync"	                  : 0x4a,	
            "fdatasync"	              : 0x4b,	
            "truncate"	              : 0x4c,	
            "ftruncate"	              : 0x4d,	
            "getdents"	              : 0x4e,	
            "getcwd"	              : 0x4f,	
            "chdir"	                  : 0x50,	
            "fchdir"	              : 0x51,	
            "rename"	              : 0x52,	
            "mkdir"	                  : 0x53,	
            "rmdir"	                  : 0x54,	
            "creat"	                  : 0x55,	
            "link"	                  : 0x56,	
            "unlink"	              : 0x57,	
            "symlink"	              : 0x58,	
            "readlink"	              : 0x59,	
            "chmod"	                  : 0x5a,	
            "fchmod"	              : 0x5b,	
            "chown"	                  : 0x5c,	
            "fchown"	              : 0x5d,	
            "lchown"	              : 0x5e,	
            "umask"	                  : 0x5f,	
            "gettimeofday"	          : 0x60,	
            "getrlimit"	              : 0x61,	
            "getrusage"	              : 0x62,	
            "sysinfo"	              : 0x63,	
            "times"	                  : 0x64,	
            "ptrace"	              : 0x65,	
            "getuid"	              : 0x66,	
            "syslog"	              : 0x67,	
            "getgid"	              : 0x68,	
            "setuid"	              : 0x69,	
            "setgid"	              : 0x6a,	
            "geteuid"	              : 0x6b,	
            "getegid"	              : 0x6c,	
            "setpgid"	              : 0x6d,	
            "getppid"	              : 0x6e,	
            "getpgrp"	              : 0x6f,	
            "setsid"	              : 0x70,	
            "setreuid"	              : 0x71,	
            "setregid"	              : 0x72,	
            "getgroups"	              : 0x73,	
            "setgroups"	              : 0x74,	
            "setresuid"	              : 0x75,	
            "getresuid"	              : 0x76,	
            "setresgid"	              : 0x77,	
            "getresgid"	              : 0x78,	
            "getpgid"	              : 0x79,	
            "setfsuid"	              : 0x7a,	
            "setfsgid"	              : 0x7b,	
            "getsid"	              : 0x7c,	
            "capget"	              : 0x7d,	
            "capset"	              : 0x7e,	
            "rt_sigpending"	          : 0x7f,	
            "rt_sigtimedwait"	      : 0x80,	
            "rt_sigqueueinfo"	      : 0x81,	
            "rt_sigsuspend"	          : 0x82,	
            "sigaltstack"	          : 0x83,	
            "utime"	                  : 0x84,	
            "mknod"	                  : 0x85,	
            "uselib"	              : 0x86,	
            "personality"             : 0x87,	
            "ustat"	                  : 0x88,	
            "statfs"	              : 0x89,	
            "fstatfs"	              : 0x8a,	
            "sysfs"	                  : 0x8b,	
            "getpriority"	          : 0x8c,	
            "setpriority"	          : 0x8d,	
            "sched_setparam"	      : 0x8e,	
            "sched_getparam"	      : 0x8f,	
            "sched_setscheduler"	  : 0x90,	
            "sched_getscheduler"	  : 0x91,	
            "sched_get_priority_max"  : 0x92,	
            "sched_get_priority_min"  : 0x93,	
            "sched_rr_get_interval"	  : 0x94,	
            "mlock"	                  : 0x95,	
            "munlock"	              : 0x96,	
            "mlockall"	              : 0x97,	
            "munlockall"	          : 0x98,	
            "vhangup"	              : 0x99,	
            "modify_ldt"	          : 0x9a,	
            "pivot_root"	          : 0x9b,	
            "_sysctl"	              : 0x9c,	
            "prctl"	                  : 0x9d,	
            "arch_prctl"	          : 0x9e,	
            "adjtimex"	              : 0x9f,	
            "setrlimit"	              : 0xa0,	
            "chroot"	              : 0xa1,	
            "sync"	                  : 0xa2,	
            "acct"	                  : 0xa3,	
            "settimeofday"	          : 0xa4,	
            "mount"	                  : 0xa5,	
            "umount2"	              : 0xa6,	
            "swapon"	              : 0xa7,	
            "swapoff"	              : 0xa8,	
            "reboot"	              : 0xa9,	
            "sethostname"             : 0xaa,	
            "setdomainname"	          : 0xab,	
            "iopl"	                  : 0xac,	
            "ioperm"	              : 0xad,	
            "create_module"	          : 0xae,	
            "init_module"	          : 0xaf,	
            "delete_module"	          : 0xb0,	
            "get_kernel_syms"	      : 0xb1,	
            "query_module"	          : 0xb2,	
            "quotactl"	              : 0xb3,	
            "nfsservctl"	          : 0xb4,	
            "getpmsg"	              : 0xb5,	
            "putpmsg"	              : 0xb6,	
            "afs_syscall"	          : 0xb7,	
            "tuxcall"	              : 0xb8,	
            "security"	              : 0xb9,	
            "gettid"	              : 0xba,	
            "readahead"	              : 0xbb,	
            "setxattr"	              : 0xbc,	
            "lsetxattr"	              : 0xbd,	
            "fsetxattr"	              : 0xbe,	
            "getxattr"	              : 0xbf,	
            "lgetxattr"	              : 0xc0,	
            "fgetxattr"	              : 0xc1,	
            "listxattr"	              : 0xc2,	
            "llistxattr"	          : 0xc3,	
            "flistxattr"	          : 0xc4,	
            "removexattr"	          : 0xc5,	
            "lremovexattr"	          : 0xc6,	
            "fremovexattr"	          : 0xc7,	
            "tkill"	                  : 0xc8,	
            "time"	                  : 0xc9,	
            "futex"	                  : 0xca,	
            "sched_setaffinity"	      : 0xcb,	
            "sched_getaffinity"	      : 0xcc,	
            "set_thread_area"	      : 0xcd,	
            "io_setup"	              : 0xce,	
            "io_destroy"	          : 0xcf,	
            "io_getevents"	          : 0xd0,	
            "io_submit"	              : 0xd1,	
            "io_cancel"	              : 0xd2,	
            "get_thread_area"	      : 0xd3,	
            "lookup_dcookie"	      : 0xd4,	
            "epoll_create"	          : 0xd5,	
            "epoll_ctl_old"	          : 0xd6,	
            "epoll_wait_old"	      : 0xd7,	
            "remap_file_pages"	      : 0xd8,	
            "getdents64"	          : 0xd9,	
            "set_tid_address"	      : 0xda,	
            "restart_syscall"	      : 0xdb,	
            "semtimedop"	          : 0xdc,	
            "fadvise64"	              : 0xdd,	
            "timer_create"	          : 0xde,	
            "timer_settime"	          : 0xdf,	
            "timer_gettime"	          : 0xe0,	
            "timer_getoverrun"	      : 0xe1,	
            "timer_delete"	          : 0xe2,	
            "clock_settime"	          : 0xe3,	
            "clock_gettime"	          : 0xe4,	
            "clock_getres"	          : 0xe5,	
            "clock_nanosleep"	      : 0xe6,	
            "exit_group"	          : 0xe7,	
            "epoll_wait"	          : 0xe8,	
            "epoll_ctl"	              : 0xe9,	
            "tgkill"	              : 0xea,	
            "utimes"	              : 0xeb,	
            "vserver"	              : 0xec,	
            "mbind"	                  : 0xed,	
            "set_mempolicy"	          : 0xee,	
            "get_mempolicy"	          : 0xef,	
            "mq_open"	              : 0xf0,	
            "mq_unlink"	              : 0xf1,	
            "mq_timedsend"	          : 0xf2,
            "mq_timedreceive"	      : 0xf3,	
            "mq_notify"	              : 0xf4,	
            "mq_getsetattr"	          : 0xf5,	
            "kexec_load"	          : 0xf6,	
            "waitid"	              : 0xf7,	
            "add_key"	              : 0xf8,	
            "request_key"	          : 0xf9,	
            "keyctl"	              : 0xfa,	
            "ioprio_set"	          : 0xfb,	
            "ioprio_get"	          : 0xfc,	
            "inotify_init"	          : 0xfd,	
            "inotify_add_watch"	      : 0xfe,	
            "inotify_rm_watch"	      : 0xff,	
            "migrate_pages"	          : 0x100,	
            "openat"	              : 0x101,	
            "mkdirat"	              : 0x102,	
            "mknodat"	              : 0x103,	
            "fchownat"	              : 0x104,	
            "futimesat"	              : 0x105,	
            "newfstatat"	          : 0x106,	
            "unlinkat"	              : 0x107,	
            "renameat"	              : 0x108,	
            "linkat"	              : 0x109,	
            "symlinkat"	              : 0x10a,	
            "readlinkat"	          : 0x10b,	
            "fchmodat"	              : 0x10c,	
            "faccessat"	              : 0x10d,	
            "pselect6"	              : 0x10e,	
            "ppoll"	                  : 0x10f,	
            "unshare"	              : 0x110,	
            "set_robust_list"	      : 0x111,	
            "get_robust_list"	      : 0x112,	
            "splice"	              : 0x113,	
            "tee"	                  : 0x114,	
            "sync_file_range"	      : 0x115,	
            "vmsplice"	              : 0x116,	
            "move_pages"	          : 0x117,	
            "utimensat"	              : 0x118,	
            "epoll_pwait"	          : 0x119,	
            "signalfd"	              : 0x11a,	
            "timerfd_create"	      : 0x11b,	
            "eventfd"	              : 0x11c,	
            "fallocate"	              : 0x11d,	
            "timerfd_settime"	      : 0x11e,	
            "timerfd_gettime"	      : 0x11f,	
            "accept4"	              : 0x120,	
            "signalfd4"	              : 0x121,	
            "eventfd2"	              : 0x122,	
            "epoll_create1"	          : 0x123,	
            "dup3"	                  : 0x124,	
            "pipe2"	                  : 0x125,	
            "inotify_init1"	          : 0x126,	
            "preadv"	              : 0x127,	
            "pwritev"	              : 0x128,	
            "rt_tgsigqueueinfo"	      : 0x129,	
            "perf_event_open"	      : 0x12a,	
            "recvmmsg"	              : 0x12b,	
            "fanotify_init"	          : 0x12c,	
            "fanotify_mark"	          : 0x12d,	
            "prlimit64"	              : 0x12e,	
            "name_to_handle_at"	      : 0x12f,	
            "open_by_handle_at"	      : 0x130,	
            "clock_adjtime"	          : 0x131,	
            "syncfs"	              : 0x132,	
            "sendmmsg"	              : 0x133,	
            "setns"	                  : 0x134,	
            "getcpu"	              : 0x135,	
            "process_vm_readv"	      : 0x136,	
            "process_vm_writev"	      : 0x137,	
            "kcmp"	                  : 0x138,	
            "finit_module"	          : 0x139,	
            "sched_setattr"	          : 0x13a,	
            "sched_getattr"	          : 0x13b,	
            "renameat2"	              : 0x13c,	
            "seccomp"	              : 0x13d,	
            "getrandom"	              : 0x13e,	
            "memfd_create"	          : 0x13f,	
            "kexec_file_load"	      : 0x140,	
            "bpf"	                  : 0x141,	
            "execveat"	              : 0x142,	
            "userfaultfd"	          : 0x143,	
            "membarrier"	          : 0x144,	
            "mlock2"	              : 0x145,	
            "copy_file_range"	      : 0x146,	
            "preadv2"	              : 0x147,	
            "pwritev2"	              : 0x148,	
            "pkey_mprotect"	          : 0x149,	
            "pkey_alloc"	          : 0x14a,	
            "pkey_free"	              : 0x14b,	
            "statx"	                  : 0x14c,
        }
    }

    for syscall_name, syscall_value in syscalls[smartarch.arch_used].items():
        if syscall_name in syscall_list:
            syscall_table[syscall_name] = syscall_value

    return syscall_table
