% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelUnits.R
\name{labelUnits}
\alias{labelUnits}
\title{labelUnits}
\usage{
labelUnits(x, ...)
}
\arguments{
\item{x}{A matrix obtained with \code{univariateTable}.}

\item{...}{not used}
}
\value{
The re-labeled matrix
}
\description{
Label output tables
}
\details{
Modify labels and values of variables in summary tables
}
\examples{

data(Diabetes)
tab <- summary(univariateTable(gender~AgeGroups+chol+waist,data=Diabetes))
publish(tab)
ltab <- labelUnits(tab,"chol"="Cholesterol (mg/dL)","<40"="younger than 40")
publish(ltab)

## pass labels immediately to utable
utable(gender~AgeGroups+chol+waist,data=Diabetes,
      "chol"="Cholesterol (mg/dL)","<40"="younger than 40")

## sometimes useful to state explicitly which variables value
## should be re-labelled
utable(gender~AgeGroups+chol+waist,data=Diabetes,
      "chol"="Cholesterol (mg/dL)","AgeGroups.<40"="younger than 40")
}
\seealso{
univariateTable
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
