% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_uniform.R
\name{dist_uniform}
\alias{dist_uniform}
\title{The Uniform distribution}
\usage{
dist_uniform(min, max)
}
\arguments{
\item{min, max}{lower and upper limits of the distribution.  Must be finite.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A distribution with constant density on an interval.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_uniform.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_uniform.html}

In the following, let \eqn{X} be a Uniform random variable with parameters
\code{min} = \eqn{a} and \code{max} = \eqn{b}.

\strong{Support}: \eqn{[a, b]}

\strong{Mean}: \eqn{\frac{a + b}{2}}

\strong{Variance}: \eqn{\frac{(b - a)^2}{12}}

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = \frac{1}{b - a}
  }{
    f(x) = 1 / (b - a)
  }

for \eqn{x \in [a, b]}{x in [a, b]}, and \eqn{f(x) = 0} otherwise.

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    F(x) = \frac{x - a}{b - a}
  }{
    F(x) = (x - a) / (b - a)
  }

for \eqn{x \in [a, b]}{x in [a, b]}, with \eqn{F(x) = 0} for \eqn{x < a}
and \eqn{F(x) = 1} for \eqn{x > b}.

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = \frac{e^{tb} - e^{ta}}{t(b - a)}
  }{
    E(e^(tX)) = (e^(tb) - e^(ta)) / (t(b - a))
  }

for \eqn{t \neq 0}{t != 0}, and \eqn{E(e^{tX}) = 1} for \eqn{t = 0}.

\strong{Skewness}: \eqn{0}

\strong{Excess Kurtosis}: \eqn{-\frac{6}{5}}{-6/5}
}
\examples{
dist <- dist_uniform(min = c(3, -2), max = c(5, 4))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Uniform]{stats::Uniform}
}
