/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Message;
import org.xbill.DNS.NioClient;
import org.xbill.DNS.Type;
import org.xbill.DNS.io.TcpIoClient;

final class NioTcpClient
extends NioClient
implements TcpIoClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NioTcpClient.class);
    private final Queue<ChannelState> registrationQueue = new ConcurrentLinkedQueue<ChannelState>();
    private final Map<ChannelKey, ChannelState> channelMap = new ConcurrentHashMap<ChannelKey, ChannelState>();

    NioTcpClient() {
        NioTcpClient.setRegistrationsTask(this::processPendingRegistrations, true);
        NioTcpClient.setTimeoutTask(this::checkTransactionTimeouts, true);
        NioTcpClient.setCloseTask(this::closeTcp, true);
    }

    private void processPendingRegistrations(Selector selector) {
        while (!this.registrationQueue.isEmpty()) {
            ChannelState state = this.registrationQueue.poll();
            if (state == null) continue;
            try {
                if (!state.channel.isConnected()) {
                    state.channel.register(selector, 8, state);
                    continue;
                }
                state.channel.keyFor(selector).interestOps(4);
            }
            catch (IOException e) {
                state.handleChannelException(e);
            }
        }
    }

    private void checkTransactionTimeouts() {
        for (ChannelState state : this.channelMap.values()) {
            Iterator it = state.pendingTransactions.iterator();
            while (it.hasNext()) {
                Transaction t = (Transaction)it.next();
                if (t.endTime - System.nanoTime() >= 0L) continue;
                t.f.completeExceptionally(new SocketTimeoutException("Query timed out"));
                it.remove();
            }
        }
    }

    private void closeTcp() {
        this.registrationQueue.clear();
        EOFException closing = new EOFException("Client is closing");
        this.channelMap.forEach((key, state) -> {
            state.handleTransactionException(closing);
            ((ChannelState)state).handleChannelException(closing);
        });
        this.channelMap.clear();
    }

    @Override
    public CompletableFuture<byte[]> sendAndReceiveTcp(InetSocketAddress local, InetSocketAddress remote, Message query, byte[] data, Duration timeout) {
        CompletableFuture<byte[]> f = new CompletableFuture<byte[]>();
        try {
            Selector selector = NioTcpClient.selector();
            long endTime = System.nanoTime() + timeout.toNanos();
            ChannelState channel = this.channelMap.computeIfAbsent(new ChannelKey(local, remote), key -> {
                log.debug("Opening async channel for l={}/r={}", (Object)local, (Object)remote);
                SocketChannel c = null;
                try {
                    c = SocketChannel.open();
                    c.configureBlocking(false);
                    if (local != null) {
                        c.bind(local);
                    }
                    c.connect(remote);
                    return new ChannelState(c);
                }
                catch (IOException e) {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    f.completeExceptionally(e);
                    return null;
                }
            });
            if (channel != null) {
                log.trace("Creating transaction for id {} ({}/{})", query.getHeader().getID(), query.getQuestion().getName(), Type.string(query.getQuestion().getType()));
                Transaction t = new Transaction(query, data, endTime, channel.channel, f);
                channel.pendingTransactions.add(t);
                this.registrationQueue.add(channel);
                selector.wakeup();
            }
        }
        catch (IOException e) {
            f.completeExceptionally(e);
        }
        return f;
    }

    private class ChannelState
    implements NioClient.KeyProcessor {
        private final SocketChannel channel;
        final Queue<Transaction> pendingTransactions = new ConcurrentLinkedQueue<Transaction>();
        ByteBuffer responseLengthData = ByteBuffer.allocate(2);
        ByteBuffer responseData = ByteBuffer.allocate(65535);
        int readState = 0;

        @Override
        public void processReadyKey(SelectionKey key) {
            if (key.isValid()) {
                if (key.isConnectable()) {
                    this.processConnect(key);
                } else {
                    if (key.isWritable()) {
                        this.processWrite(key);
                    }
                    if (key.isReadable()) {
                        this.processRead();
                    }
                }
            }
        }

        void handleTransactionException(IOException e) {
            Iterator it = this.pendingTransactions.iterator();
            while (it.hasNext()) {
                Transaction t = (Transaction)it.next();
                t.f.completeExceptionally(e);
                it.remove();
            }
        }

        private void handleChannelException(IOException e) {
            this.handleTransactionException(e);
            for (Map.Entry entry : NioTcpClient.this.channelMap.entrySet()) {
                if (entry.getValue() != this) continue;
                NioTcpClient.this.channelMap.remove(entry.getKey());
                try {
                    this.channel.close();
                }
                catch (IOException ex) {
                    log.warn("Failed to close channel l={}/r={}", ((ChannelKey)entry.getKey()).local, ((ChannelKey)entry.getKey()).remote, ex);
                }
                return;
            }
        }

        private void processConnect(SelectionKey key) {
            try {
                this.channel.finishConnect();
                key.interestOps(4);
            }
            catch (IOException e) {
                this.handleChannelException(e);
            }
        }

        private void processRead() {
            try {
                int read;
                if (this.readState == 0) {
                    read = this.channel.read(this.responseLengthData);
                    if (read < 0) {
                        this.handleChannelException(new EOFException());
                        return;
                    }
                    if (this.responseLengthData.position() == 2) {
                        int length = ((this.responseLengthData.get(0) & 0xFF) << 8) + (this.responseLengthData.get(1) & 0xFF);
                        this.responseLengthData.flip();
                        this.responseData.limit(length);
                        this.readState = 1;
                    }
                }
                if ((read = this.channel.read(this.responseData)) < 0) {
                    this.handleChannelException(new EOFException());
                    return;
                }
                if (this.responseData.hasRemaining()) {
                    return;
                }
            }
            catch (IOException e) {
                this.handleChannelException(e);
                return;
            }
            this.readState = 0;
            this.responseData.flip();
            byte[] data = new byte[this.responseData.limit()];
            System.arraycopy(this.responseData.array(), this.responseData.arrayOffset(), data, 0, this.responseData.limit());
            if (data.length < 2) {
                NioClient.verboseLog("TCP read: response too short for a valid reply, discarding", this.channel.socket().getLocalSocketAddress(), this.channel.socket().getRemoteSocketAddress(), data);
                return;
            }
            int id = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
            NioClient.verboseLog("TCP read: transaction id=" + id, this.channel.socket().getLocalSocketAddress(), this.channel.socket().getRemoteSocketAddress(), data);
            Iterator it = this.pendingTransactions.iterator();
            while (it.hasNext()) {
                Transaction t = (Transaction)it.next();
                int qid = t.query.getHeader().getID();
                if (id != qid) continue;
                t.f.complete(data);
                it.remove();
                return;
            }
            log.warn("Transaction for answer to id {} not found", (Object)id);
        }

        private void processWrite(SelectionKey key) {
            Iterator it = this.pendingTransactions.iterator();
            while (it.hasNext()) {
                Transaction t = (Transaction)it.next();
                try {
                    if (t.send()) continue;
                    key.interestOps(4);
                    return;
                }
                catch (IOException e) {
                    t.f.completeExceptionally(e);
                    it.remove();
                }
            }
            key.interestOps(1);
        }

        @Generated
        public ChannelState(SocketChannel channel) {
            this.channel = channel;
        }
    }

    private static class Transaction {
        private final Message query;
        private final byte[] queryData;
        private final long endTime;
        private final SocketChannel channel;
        private final CompletableFuture<byte[]> f;
        private ByteBuffer queryDataBuffer;
        long bytesWrittenTotal = 0L;

        boolean send() throws IOException {
            if (this.bytesWrittenTotal == (long)(this.queryData.length + 2)) {
                return true;
            }
            if (this.queryDataBuffer == null) {
                this.queryDataBuffer = ByteBuffer.allocate(this.queryData.length + 2);
                this.queryDataBuffer.put((byte)(this.queryData.length >>> 8));
                this.queryDataBuffer.put((byte)(this.queryData.length & 0xFF));
                this.queryDataBuffer.put(this.queryData);
                this.queryDataBuffer.flip();
            }
            NioClient.verboseLog("TCP write: transaction id=" + this.query.getHeader().getID(), this.channel.socket().getLocalSocketAddress(), this.channel.socket().getRemoteSocketAddress(), this.queryDataBuffer);
            while (this.queryDataBuffer.hasRemaining()) {
                long bytesWritten = this.channel.write(this.queryDataBuffer);
                this.bytesWrittenTotal += bytesWritten;
                if (bytesWritten == 0L) {
                    log.debug("Insufficient room for the data in the underlying output buffer for transaction {}, retrying", (Object)this.query.getHeader().getID());
                    return false;
                }
                if (this.bytesWrittenTotal >= (long)this.queryData.length) continue;
                log.debug("Wrote {} of {} bytes data for transaction {}", this.bytesWrittenTotal, this.queryData.length, this.query.getHeader().getID());
            }
            log.debug("Send for transaction {} is complete, wrote {} bytes", (Object)this.query.getHeader().getID(), (Object)this.bytesWrittenTotal);
            return true;
        }

        @Generated
        public Transaction(Message query, byte[] queryData, long endTime, SocketChannel channel, CompletableFuture<byte[]> f) {
            this.query = query;
            this.queryData = queryData;
            this.endTime = endTime;
            this.channel = channel;
            this.f = f;
        }
    }

    private static class ChannelKey {
        final InetSocketAddress local;
        final InetSocketAddress remote;

        @Generated
        public ChannelKey(InetSocketAddress local, InetSocketAddress remote) {
            this.local = local;
            this.remote = remote;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelKey)) {
                return false;
            }
            ChannelKey other = (ChannelKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            InetSocketAddress this$local = this.local;
            InetSocketAddress other$local = other.local;
            if (this$local == null ? other$local != null : !((Object)this$local).equals(other$local)) {
                return false;
            }
            InetSocketAddress this$remote = this.remote;
            InetSocketAddress other$remote = other.remote;
            return !(this$remote == null ? other$remote != null : !((Object)this$remote).equals(other$remote));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ChannelKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            InetSocketAddress $local = this.local;
            result = result * 59 + ($local == null ? 43 : ((Object)$local).hashCode());
            InetSocketAddress $remote = this.remote;
            result = result * 59 + ($remote == null ? 43 : ((Object)$remote).hashCode());
            return result;
        }
    }
}

