/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tree;

import com.jsql.util.I18nUtil;
import com.jsql.view.swing.tree.ProgressBarPausable;
import com.jsql.view.swing.tree.model.AbstractNodeModel;
import com.jsql.view.swing.util.UiStringUtil;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class PanelNode
extends JPanel {
    private final JLabel iconNode = new JLabel();
    private final JLabel loaderWait = new JLabel();
    private final ProgressBarPausable progressBar = new ProgressBarPausable();
    private final JLabel nodeLabel = new JLabel();
    private final JTextField textFieldEditable = new JTextField(15);

    public PanelNode(JTree tree, DefaultMutableTreeNode currentNode) {
        this.loaderWait.setIcon(UiUtil.HOURGLASS.getIcon());
        this.loaderWait.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.progressBar.setPreferredSize(new Dimension(20, 20));
        this.progressBar.setBorder(BorderFactory.createEmptyBorder(4, 3, 4, 3));
        this.nodeLabel.setOpaque(true);
        this.iconNode.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new BoxLayout(this, 2));
        Stream.of(this.iconNode, this.loaderWait, this.progressBar, this.nodeLabel, this.textFieldEditable).forEach(component -> {
            this.add((Component)component);
            component.setVisible(false);
        });
        this.setComponentOrientation(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale()));
        this.initTextFieldEditable(tree, currentNode);
    }

    private void initTextFieldEditable(final JTree tree, final DefaultMutableTreeNode currentNode) {
        this.textFieldEditable.addActionListener(e -> {
            AbstractNodeModel nodeModel = (AbstractNodeModel)currentNode.getUserObject();
            nodeModel.setIsEdited(false);
            this.nodeLabel.setVisible(true);
            this.textFieldEditable.setVisible(false);
            tree.requestFocusInWindow();
            nodeModel.getElementDatabase().setElementValue(new String(this.textFieldEditable.getText().getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
            this.nodeLabel.setText(UiStringUtil.detectUtf8Html(nodeModel.getElementDatabase().getLabelWithCount()));
            tree.revalidate();
            tree.repaint();
        });
        this.textFieldEditable.addFocusListener(new FocusAdapter(this){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractNodeModel nodeModel = (AbstractNodeModel)currentNode.getUserObject();
                nodeModel.setIsEdited(false);
                tree.revalidate();
                tree.repaint();
            }
        });
        KeyAdapter keyAdapterF2 = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AbstractNodeModel nodeModel = (AbstractNodeModel)currentNode.getUserObject();
                if (e.getKeyCode() == 113 && !nodeModel.isRunning()) {
                    nodeModel.setIsEdited(true);
                    PanelNode.this.nodeLabel.setVisible(false);
                    PanelNode.this.textFieldEditable.setVisible(true);
                    PanelNode.this.textFieldEditable.requestFocusInWindow();
                    tree.revalidate();
                    tree.repaint();
                }
            }
        };
        this.addKeyListener(keyAdapterF2);
        this.textFieldEditable.addKeyListener(keyAdapterF2);
    }

    public void setIconNode(Icon newIcon) {
        this.iconNode.setIcon(newIcon);
    }

    public void showIcon() {
        this.iconNode.setVisible(true);
    }

    public void hideIcon() {
        this.iconNode.setVisible(false);
    }

    public void setLoaderIcon(Icon newIcon) {
        this.loaderWait.setIcon(newIcon);
    }

    public void showLoader() {
        this.loaderWait.setVisible(true);
    }

    public ProgressBarPausable getProgressBar() {
        return this.progressBar;
    }

    public JLabel getNodeLabel() {
        return this.nodeLabel;
    }

    public JTextField getTextFieldEditable() {
        return this.textFieldEditable;
    }
}

