/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.terminal;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.terminal.EmptyFocusCopy;
import com.jsql.view.swing.terminal.util.BlockCaret;
import com.jsql.view.swing.terminal.util.KeyAdapterTerminal;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractExploit
extends JTextPane {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final AtomicBoolean isEdited = new AtomicBoolean(false);
    private final String host;
    private String[] loginPassword = null;
    private final UUID uuidShell;
    private final String urlShell;
    private final transient Style style = this.addStyle("Necrophagist's next album is 2014.", null);
    private String prompt = "";
    private final String labelShell;

    protected AbstractExploit(UUID uuidShell, String urlShell, String labelShell) throws MalformedURLException, URISyntaxException {
        this(uuidShell, urlShell, labelShell, true);
    }

    protected AbstractExploit(UUID uuidShell, String urlShell, String labelShell, boolean isAddingPrompt) throws MalformedURLException, URISyntaxException {
        this.uuidShell = uuidShell;
        this.urlShell = urlShell;
        this.labelShell = labelShell;
        URL url = StringUtils.isEmpty(urlShell) ? new URI(MediatorHelper.model().getMediatorUtils().connectionUtil().getUrlByUser()).toURL() : new URI(urlShell).toURL();
        this.host = url.getHost();
        this.setFont(new Font("Ubuntu Mono", 0, UIManager.getFont("TextArea.font").getSize()));
        this.setCaret(new BlockCaret());
        this.setBackground(Color.BLACK);
        this.setForeground(Color.LIGHT_GRAY);
        if (isAddingPrompt) {
            this.displayPrompt(true);
        } else {
            this.append("Waiting for reverse connection...\n");
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setTransferHandler(null);
        this.setHighlighter(null);
        this.addMouseListener(new EmptyFocusCopy(this));
        this.addKeyListener(new KeyAdapterTerminal(this));
    }

    public abstract void action(String var1, UUID var2, String var3, String ... var4);

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean isPromptVisible) {
        this.isEdited.set(false);
        this.setEditable(true);
        if (isPromptVisible) {
            this.displayPrompt(false);
        }
        this.setCaretPosition(this.getDocument().getLength());
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void append(String string) {
        try {
            Document doc = this.getDocument();
            doc.insertString(doc.getLength(), string, null);
        }
        catch (BadLocationException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    public void displayPrompt(boolean isAddingPrompt) {
        StyleConstants.setUnderline(this.style, true);
        this.appendPrompt("jsql", Color.LIGHT_GRAY, isAddingPrompt);
        StyleConstants.setUnderline(this.style, false);
        this.appendPrompt(" " + this.labelShell, Color.LIGHT_GRAY, isAddingPrompt);
        this.appendPrompt("[", new Color(3325746), isAddingPrompt);
        this.appendPrompt(this.host, new Color(12566297), isAddingPrompt);
        this.appendPrompt("]", new Color(3325746), isAddingPrompt);
        this.appendPrompt(" >", new Color(12543076), isAddingPrompt);
        this.appendPrompt(" ", Color.LIGHT_GRAY, isAddingPrompt);
    }

    private void appendPrompt(String string, Color color, boolean isAddingPrompt) {
        try {
            StyleConstants.setForeground(this.style, color);
            this.getStyledDocument().insertString(this.getStyledDocument().getLength(), string, this.style);
            if (isAddingPrompt) {
                this.prompt = this.prompt + string;
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getUI().getPreferredSize((JComponent)this).width <= this.getParent().getSize().width;
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        String errorMsg = "Can't translate offset to line";
        Document doc = this.getDocument();
        if (offset < 0) {
            throw new BadLocationException(errorMsg, -1);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException(errorMsg, doc.getLength() + 1);
        }
        Element map = doc.getDefaultRootElement();
        return map.getElementIndex(offset);
    }

    public int getLineStartOffset(int line) throws BadLocationException {
        Element map = this.getDocument().getDefaultRootElement();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= map.getElementCount()) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element lineElem = map.getElement(line);
        return lineElem.getStartOffset();
    }

    public AtomicBoolean getIsEdited() {
        return this.isEdited;
    }

    public UUID getUuidShell() {
        return this.uuidShell;
    }

    public String getUrlShell() {
        return this.urlShell;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String[] getLoginPassword() {
        return this.loginPassword;
    }

    public void setLoginPassword(String[] loginPassword) {
        this.loginPassword = loginPassword;
    }
}

