/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tab;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.jsql.model.bean.database.AbstractElementDatabase;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import com.jsql.util.reverse.ModelReverse;
import com.jsql.view.swing.action.ActionCloseTabResult;
import com.jsql.view.swing.action.HotkeyUtil;
import com.jsql.view.swing.popupmenu.JPopupMenuText;
import com.jsql.view.swing.tab.TabHeader;
import com.jsql.view.swing.tab.TabbedPaneMouseWheelListener;
import com.jsql.view.swing.tab.dnd.DnDTabbedPane;
import com.jsql.view.swing.tab.dnd.TabTransferHandler;
import com.jsql.view.swing.table.PanelTable;
import com.jsql.view.swing.terminal.AbstractExploit;
import com.jsql.view.swing.terminal.ExploitReverseShell;
import com.jsql.view.swing.text.JPopupTextArea;
import com.jsql.view.swing.text.JTextFieldPlaceholder;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.RadioItemNonClosing;
import com.jsql.view.swing.util.UiStringUtil;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public class TabResults
extends DnDTabbedPane {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final String TAB_EXPLOIT_FAILURE_INCORRECT_URL = "Tab exploit failure: incorrect URL";
    public static final String UDF_SHELL = "UDF shell";
    public static final String SQL_SHELL = "SQL shell";
    public static final String REVERSE_SHELL = "Reverse shell";
    public static final String WEB_SHELL = "webShell";
    public static final String TAB_RESULTS = "tabResults";

    public TabResults() {
        this.setName(TAB_RESULTS);
        this.setTabLayoutPolicy(1);
        this.setTransferHandler(new TabTransferHandler());
        this.putClientProperty("JTabbedPane.tabClosable", true);
        this.putClientProperty("JTabbedPane.tabCloseCallback", ActionCloseTabResult::perform);
        UIManager.put("TabbedPane.closeHoverForeground", LogLevelUtil.COLOR_RED);
        HotkeyUtil.addShortcut(this);
        this.addMouseWheelListener(new TabbedPaneMouseWheelListener());
        MediatorHelper.register(this);
    }

    public void addFileTab(String label, String content, String path) {
        MediatorHelper.frame().getSplitNS().invokeLaterWithSplitOrientation(() -> {
            JTextArea fileText = (JTextArea)new JPopupTextArea().getProxy();
            fileText.setText(content);
            fileText.setFont(new Font("Ubuntu Mono", 0, 14));
            fileText.setCaretPosition(0);
            this.addTextTab(label, path, fileText, UiUtil.DOWNLOAD.getIcon());
            MediatorHelper.tabManagersCards().addToLists(path, label);
        });
    }

    public void addAdminTab(String urlSuccess) {
        MediatorHelper.frame().getSplitNS().invokeLaterWithSplitOrientation(() -> {
            String htmlSource = "";
            try {
                htmlSource = Jsoup.clean(Jsoup.connect(urlSuccess).ignoreContentType(true).ignoreHttpErrors(true).get().html().replaceAll("<img[^>]*>", "").replaceAll("<input[^>]*type=\"?hidden\"?[^>]*>", "").replaceAll("<input[^>]*type=\"?(submit|button)\"?[^>]*>", "<div style=\"background-color:#eeeeee;text-align:center;border:1px solid black;width:100px;\">button</div>").replaceAll("<input[^>]*>", "<div style=\"text-align:center;border:1px solid black;width:100px;\">input</div>"), Safelist.relaxed().addTags("center", "div", "span").addAttributes(":all", "style"));
            }
            catch (IOException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Failure opening page: {}", (Object)e.getMessage());
            }
            catch (ExceptionInInitializerError | NoClassDefFoundError e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
            final JTextPane browser = new JTextPane();
            browser.setContentType("text/html");
            browser.setEditable(false);
            browser.setCaretPosition(0);
            try {
                browser.setText(htmlSource);
            }
            catch (IndexOutOfBoundsException | EmptyStackException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
            JMenuItem itemCopyUrl = new JMenuItem(I18nUtil.valueByKey("CONTEXT_MENU_COPY_PAGE_URL"));
            I18nViewUtil.addComponentForKey("CONTEXT_MENU_COPY_PAGE_URL", itemCopyUrl);
            JMenuItem itemCopy = new JMenuItem();
            itemCopy.setAction(browser.getActionMap().get("copy-to-clipboard"));
            itemCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
            itemCopy.setMnemonic('C');
            itemCopy.setText(I18nUtil.valueByKey("CONTEXT_MENU_COPY"));
            I18nViewUtil.addComponentForKey("CONTEXT_MENU_COPY", itemCopy);
            JMenuItem itemSelectAll = new JMenuItem();
            itemSelectAll.setAction(browser.getActionMap().get("select-all"));
            itemSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 128));
            itemSelectAll.setText(I18nUtil.valueByKey("CONTEXT_MENU_SELECT_ALL"));
            I18nViewUtil.addComponentForKey("CONTEXT_MENU_SELECT_ALL", itemSelectAll);
            itemSelectAll.setMnemonic('A');
            JPopupMenu menu = new JPopupMenu();
            menu.add(itemCopyUrl);
            menu.add(new JSeparator());
            menu.add(itemCopy);
            menu.add(itemSelectAll);
            menu.applyComponentOrientation(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale()));
            itemCopyUrl.addActionListener(actionEvent -> {
                StringSelection stringSelection = new StringSelection(urlSuccess);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            });
            itemSelectAll.addActionListener(actionEvent -> browser.selectAll());
            browser.addFocusListener(new FocusAdapter(this){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    browser.getCaret().setVisible(true);
                    browser.getCaret().setSelectionVisible(true);
                }
            });
            browser.addMouseListener(new BrowserMouseAdapter(browser, menu));
            JScrollPane scroller = new JScrollPane(browser);
            MediatorHelper.tabResults().addTab(urlSuccess.replaceAll(".*/", "") + " ", scroller);
            try {
                MediatorHelper.tabResults().setSelectedComponent(scroller);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
            MediatorHelper.tabResults().setToolTipTextAt(MediatorHelper.tabResults().indexOfComponent(scroller), String.format("<html>%s</html>", urlSuccess));
            TabHeader header = new TabHeader(urlSuccess.replaceAll(".*/", ""), UiUtil.ADMIN.getIcon());
            MediatorHelper.tabResults().setTabComponentAt(MediatorHelper.tabResults().indexOfComponent(scroller), header);
            browser.setCaretPosition(0);
            MediatorHelper.tabResults().updateUI();
        });
    }

    public void addReportTab(String content) {
        MediatorHelper.frame().getSplitNS().invokeLaterWithSplitOrientation(() -> {
            final JEditorPane editorPane = new JEditorPane();
            editorPane.setContentType("text/html");
            editorPane.setText("<html><span style=\"white-space: nowrap; font-family:'Ubuntu Mono'\">" + content + "</span></html>");
            editorPane.setFont(UIManager.getFont("TextArea.font"));
            editorPane.setDragEnabled(true);
            editorPane.setEditable(false);
            editorPane.setCaretPosition(0);
            editorPane.getCaret().setBlinkRate(0);
            editorPane.setCursor(Cursor.getPredefinedCursor(2));
            editorPane.setComponentPopupMenu(new JPopupMenuText(editorPane));
            editorPane.addHyperlinkListener(linkEvent -> {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(linkEvent.getEventType())) {
                    try {
                        Desktop.getDesktop().browse(linkEvent.getURL().toURI());
                    }
                    catch (IOException | UnsupportedOperationException | URISyntaxException e) {
                        LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Failing to browse Url", (Throwable)e);
                    }
                }
            });
            editorPane.addFocusListener(new FocusAdapter(this){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    editorPane.getCaret().setVisible(true);
                    editorPane.getCaret().setSelectionVisible(true);
                    editorPane.getCaret().setBlinkRate(0);
                }
            });
            UiUtil.init(editorPane);
            this.addTextTab("Vulnerability report", "Analysis report with all payloads detected", editorPane, UiUtil.APP_ICON.getIcon());
        });
    }

    public void addTextTab(String label, String toolTipText, JComponent componentText, FlatSVGIcon icon) {
        JScrollPane scroller = new JScrollPane(componentText);
        this.addTab(label + " ", scroller);
        this.setSelectedComponent(scroller);
        this.setToolTipTextAt(this.indexOfComponent(scroller), toolTipText);
        TabHeader header = new TabHeader(label, icon);
        this.setTabComponentAt(this.indexOfComponent(scroller), header);
        this.updateUI();
    }

    public void addTabExploitWeb(String url) {
        MediatorHelper.frame().getSplitNS().invokeLaterWithSplitOrientation(() -> {
            try {
                UUID terminalID = UUID.randomUUID();
                AbstractExploit terminal = new AbstractExploit(terminalID, url, "web"){

                    @Override
                    public void action(String command, UUID terminalID, String urlShell, String ... arg) {
                        MediatorHelper.model().getResourceAccess().runWebShell(command, terminalID, urlShell);
                    }
                };
                terminal.setName(WEB_SHELL);
                MediatorHelper.frame().getMapUuidShell().put(terminalID, terminal);
                JPanel panelTerminalWithReverse = this.getTerminalWithMenu(terminal);
                this.addTab("Web shell", panelTerminalWithReverse);
                this.setSelectedComponent(panelTerminalWithReverse);
                TabHeader header = new TabHeader("Web shell", UiUtil.TERMINAL.getIcon());
                this.setTabComponentAt(this.indexOfComponent(panelTerminalWithReverse), header);
                terminal.requestFocusInWindow();
                this.updateUI();
            }
            catch (MalformedURLException | URISyntaxException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, TAB_EXPLOIT_FAILURE_INCORRECT_URL, (Throwable)e);
            }
        });
    }

    public void addTabExploitReverseShell(String port) {
        MediatorHelper.frame().getSplitNS().invokeLaterWithSplitOrientation(() -> {
            try {
                UUID terminalID = UUID.randomUUID();
                ExploitReverseShell terminal = new ExploitReverseShell(terminalID, port);
                MediatorHelper.frame().getMapUuidShell().put(terminalID, terminal);
                JScrollPane scroller = new JScrollPane(terminal);
                this.addTab(REVERSE_SHELL, scroller);
                this.setSelectedComponent(scroller);
                TabHeader header = new TabHeader(REVERSE_SHELL, UiUtil.TERMINAL.getIcon());
                this.setTabComponentAt(this.indexOfComponent(scroller), header);
                terminal.requestFocusInWindow();
                this.updateUI();
            }
            catch (IOException | URISyntaxException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, TAB_EXPLOIT_FAILURE_INCORRECT_URL, (Throwable)e);
            }
        });
    }

    public void addTabExploitUdf(final BiConsumer<String, UUID> biConsumerRunCmd) {
        MediatorHelper.frame().getSplitNS().invokeLaterWithSplitOrientation(() -> {
            try {
                UUID terminalID = UUID.randomUUID();
                AbstractExploit terminal = new AbstractExploit(terminalID, null, "udf"){

                    @Override
                    public void action(String command, UUID terminalID, String urlShell, String ... arg) {
                        biConsumerRunCmd.accept(command, terminalID);
                    }
                };
                MediatorHelper.frame().getMapUuidShell().put(terminalID, terminal);
                JPanel panelTerminalWithReverse = this.getTerminalWithMenu(terminal);
                this.addTab(UDF_SHELL, panelTerminalWithReverse);
                this.setSelectedComponent(panelTerminalWithReverse);
                TabHeader header = new TabHeader(UDF_SHELL, UiUtil.TERMINAL.getIcon());
                this.setTabComponentAt(this.indexOfComponent(panelTerminalWithReverse), header);
                terminal.requestFocusInWindow();
                this.updateUI();
            }
            catch (MalformedURLException | URISyntaxException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, TAB_EXPLOIT_FAILURE_INCORRECT_URL, (Throwable)e);
            }
        });
    }

    public void addTabExploitSql(String url, String user, String pass) {
        MediatorHelper.frame().getSplitNS().invokeLaterWithSplitOrientation(() -> {
            try {
                UUID terminalID = UUID.randomUUID();
                AbstractExploit terminal = new AbstractExploit(terminalID, url, "sql"){

                    @Override
                    public void action(String cmd, UUID terminalID, String wbhPath, String ... arg) {
                        MediatorHelper.model().getResourceAccess().runSqlShell(cmd, terminalID, wbhPath, arg[0], arg[1]);
                    }
                };
                terminal.setLoginPassword(new String[]{user, pass});
                MediatorHelper.frame().getMapUuidShell().put(terminalID, terminal);
                JScrollPane scroller = new JScrollPane(terminal);
                this.addTab(SQL_SHELL, scroller);
                this.setSelectedComponent(scroller);
                TabHeader header = new TabHeader(SQL_SHELL, UiUtil.TERMINAL.getIcon());
                this.setTabComponentAt(this.indexOfComponent(scroller), header);
                terminal.requestFocusInWindow();
                this.updateUI();
            }
            catch (MalformedURLException | URISyntaxException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, TAB_EXPLOIT_FAILURE_INCORRECT_URL, (Throwable)e);
            }
        });
    }

    public void addTabValues(String[][] data, String[] columnNames, AbstractElementDatabase table) {
        PanelTable panelTable = new PanelTable(data, columnNames);
        this.addTab(StringUtil.detectUtf8(table.toString()), panelTable);
        panelTable.setComponentOrientation(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale()));
        this.setSelectedComponent(panelTable);
        TabHeader header = new TabHeader(UiStringUtil.detectUtf8Html(table.toString()), UiUtil.TABLE_BOLD.getIcon());
        this.setTabComponentAt(this.indexOfComponent(panelTable), header);
        this.updateUI();
    }

    private JPanel getTerminalWithMenu(final AbstractExploit terminal) {
        JPanel panelTerminalWithReverse = new JPanel(){

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        OverlayLayout overlay = new OverlayLayout(panelTerminalWithReverse);
        panelTerminalWithReverse.setLayout(overlay);
        JPanel panelReverseMargin = new JPanel();
        panelReverseMargin.setLayout(new BoxLayout(panelReverseMargin, 2));
        panelReverseMargin.setOpaque(false);
        panelReverseMargin.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 15));
        JLabel menuReverse = new JLabel(REVERSE_SHELL, UiUtil.ARROW_DOWN.getIcon(), 2);
        menuReverse.setName(REVERSE_SHELL);
        menuReverse.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu popupMenu = TabResults.this.showMenu(terminal);
                popupMenu.updateUI();
                popupMenu.show(e.getComponent(), e.getComponent().getX(), 5 + e.getComponent().getY() + e.getComponent().getHeight());
                popupMenu.setLocation(e.getComponent().getLocationOnScreen().x, 5 + e.getComponent().getLocationOnScreen().y + e.getComponent().getHeight());
            }
        });
        menuReverse.setMaximumSize(menuReverse.getPreferredSize());
        JScrollPane scrollerTerminal = new JScrollPane(terminal);
        scrollerTerminal.setAlignmentX(1.0f);
        scrollerTerminal.setAlignmentY(0.0f);
        panelReverseMargin.setAlignmentX(1.0f);
        panelReverseMargin.setAlignmentY(0.0f);
        panelReverseMargin.add(menuReverse);
        panelTerminalWithReverse.add(panelReverseMargin);
        panelTerminalWithReverse.add(scrollerTerminal);
        return panelTerminalWithReverse;
    }

    private JPopupMenu showMenu(AbstractExploit terminal) {
        final JPopupMenu menuReverse = new JPopupMenu();
        JMenu menuListen = new JMenu("Listen");
        menuListen.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale())) ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT);
        JPanel panelPublicAddress = new JPanel(new BorderLayout());
        panelPublicAddress.add(new JLabel("<html><b>Your public address (listener) :</b></html>"));
        menuListen.add(panelPublicAddress);
        menuListen.add(new JSeparator());
        JTextFieldPlaceholder address = new JTextFieldPlaceholder("Local IP/domain", "10.0.2.2");
        menuListen.add(address);
        final JTextFieldPlaceholder port = new JTextFieldPlaceholder("Local port", "4444");
        menuListen.add(port);
        JPanel panelServerConnection = new JPanel(new BorderLayout());
        panelServerConnection.add(new JLabel("<html><b>Server method (connector) :</b></html>"));
        menuListen.add(panelServerConnection);
        menuListen.add(new JSeparator());
        ButtonGroup buttonGroup = new ButtonGroup();
        List<ModelReverse> commandsReverse = MediatorHelper.model().getMediatorUtils().preferencesUtil().getCommandsReverse();
        commandsReverse.forEach(modelReverse -> {
            RadioItemNonClosing radio = new RadioItemNonClosing(modelReverse.getName());
            radio.setActionCommand(modelReverse.getName());
            radio.setSelected("bash".equals(modelReverse.getName()));
            buttonGroup.add(radio);
            menuListen.add(radio);
        });
        final Runnable runnableReverse = () -> {
            try {
                Thread.sleep(2500L);
                MediatorHelper.model().getMediatorUtils().preferencesUtil().getCommandsReverse().stream().filter(modelReverse -> modelReverse.getName().equals(buttonGroup.getSelection().getActionCommand())).findFirst().ifPresent(modelReverse -> MediatorHelper.model().getResourceAccess().runWebShell(String.format(modelReverse.getCommand(), address.getText(), port.getText()), null, terminal.getUrlShell(), true));
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
        };
        JPanel panelOpenIn = new JPanel(new BorderLayout());
        panelOpenIn.add(new JLabel("<html><b>Open In :</b></html>"));
        menuListen.add(panelOpenIn);
        menuListen.add(new JSeparator());
        final RadioItemNonClosing menuBuiltInShell = new RadioItemNonClosing("Built-in shell", true);
        RadioItemNonClosing menuExternalShell = new RadioItemNonClosing("External listening shell");
        ButtonGroup buttonTypeShell = new ButtonGroup();
        buttonTypeShell.add(menuBuiltInShell);
        buttonTypeShell.add(menuExternalShell);
        menuListen.add(menuBuiltInShell);
        menuListen.add(menuExternalShell);
        menuListen.add(new JSeparator());
        JPanel panelCreate = new JPanel(new BorderLayout());
        panelCreate.add(new JButton(new AbstractAction("Create reverse shell"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (menuBuiltInShell.isSelected()) {
                    MediatorHelper.tabResults().addTabExploitReverseShell(port.getText());
                }
                new Thread(runnableReverse).start();
                menuReverse.setVisible(false);
            }
        }));
        menuListen.add(panelCreate);
        JMenu menuConnect = new JMenu("Connect");
        menuConnect.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale())) ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT);
        JPanel panelServerPublicAddress = new JPanel(new BorderLayout());
        panelServerPublicAddress.add(new JLabel("<html><b>Server public address (listener) :</b></html>"));
        menuConnect.add(panelServerPublicAddress);
        menuConnect.add(new JSeparator());
        menuConnect.add(new JTextFieldPlaceholder("Target IP/domain"));
        menuConnect.add(new JTextFieldPlaceholder("Target port"));
        menuConnect.add(new JSeparator());
        JPanel panelServerListeningConnection = new JPanel(new BorderLayout());
        panelServerListeningConnection.add(new JLabel("<html><b>Server listening method :</b></html>"));
        menuConnect.add(panelServerListeningConnection);
        ButtonGroup buttonGroupListening = new ButtonGroup();
        List.of("netcat").forEach(method -> {
            JRadioButtonMenuItem radio = new JRadioButtonMenuItem((String)method){

                @Override
                protected void processMouseEvent(MouseEvent evt) {
                    if (evt.getID() == 502 && this.contains(evt.getPoint())) {
                        this.doClick();
                        this.setArmed(true);
                    } else {
                        super.processMouseEvent(evt);
                    }
                }
            };
            radio.setSelected("netcat".equals(method));
            buttonGroupListening.add(radio);
            menuConnect.add(radio);
        });
        menuConnect.add(new JSeparator());
        menuConnect.add(new JMenuItem("Create"));
        menuReverse.add(menuListen);
        menuReverse.add(menuConnect);
        return menuReverse;
    }

    private static class BrowserMouseAdapter
    extends MouseAdapter {
        private final JTextPane browser;
        private final JPopupMenu menu;

        public BrowserMouseAdapter(JTextPane browser, JPopupMenu menu) {
            this.browser = browser;
            this.menu = menu;
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            this.browser.requestFocusInWindow();
            if (evt.isPopupTrigger()) {
                this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                Arrays.stream(this.menu.getComponents()).map(a -> (JComponent)a).forEach(JComponent::updateUI);
                this.menu.updateUI();
                try {
                    this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
                catch (IllegalComponentStateException e) {
                    LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
                }
                this.menu.setLocation(ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale())) ? evt.getXOnScreen() - this.menu.getWidth() : evt.getXOnScreen(), evt.getYOnScreen());
            }
        }
    }
}

