/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.panel.util;

import com.jsql.view.swing.text.JPopupTextArea;
import com.jsql.view.swing.text.JTextAreaPlaceholder;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ButtonExpandText
extends JButton {
    public ButtonExpandText(final JTextField sourceTextField) {
        this.setPreferredSize(new Dimension(16, 16));
        this.setContentAreaFilled(false);
        this.setIcon(UiUtil.EXPAND.getIcon());
        this.setRolloverIcon(UiUtil.EXPAND_HOVER.getIcon());
        this.setPressedIcon(UiUtil.EXPAND_PRESSED.getIcon());
        final JTextArea textAreaInDialog = (JTextArea)new JPopupTextArea(new JTextAreaPlaceholder("Multiline text")).getProxy();
        textAreaInDialog.getCaret().setBlinkRate(500);
        final JDialog dialogWithTextarea = new JDialog();
        dialogWithTextarea.setUndecorated(true);
        dialogWithTextarea.getContentPane().add(new JScrollPane(textAreaInDialog));
        dialogWithTextarea.pack();
        dialogWithTextarea.addWindowFocusListener(new WindowAdapter(this){

            @Override
            public void windowLostFocus(WindowEvent e) {
                sourceTextField.setText(textAreaInDialog.getText().replace("\n", "\\n").replace("\r", "\\r"));
                dialogWithTextarea.dispose();
            }
        });
        dialogWithTextarea.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent e) {
                sourceTextField.setText(textAreaInDialog.getText().replace("\n", "\\n").replace("\r", "\\r"));
                super.windowClosing(e);
            }
        });
        this.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent e) {
                textAreaInDialog.setText(sourceTextField.getText().replace("\\n", "\n").replace("\\r", "\r"));
                dialogWithTextarea.setVisible(!dialogWithTextarea.isVisible());
                dialogWithTextarea.setSize(sourceTextField.getWidth(), 300);
                dialogWithTextarea.setLocation(sourceTextField.getLocationOnScreen());
            }
        });
        dialogWithTextarea.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        dialogWithTextarea.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialogWithTextarea.dispose();
            }
        });
    }
}

