/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.panel.consoles;

import com.jsql.util.I18nUtil;
import com.jsql.view.subscriber.Seal;
import com.jsql.view.swing.panel.consoles.CenterRenderer;
import com.jsql.view.swing.panel.consoles.CenterRendererWithIcon;
import com.jsql.view.swing.panel.consoles.TabbedPaneNetworkTab;
import com.jsql.view.swing.panel.consoles.TooltipCellRenderer;
import com.jsql.view.swing.popupmenu.JPopupMenuTable;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.AWTKeyStroke;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class NetworkTable
extends JTable {
    public static final String NETWORK_TABLE = "networkTable";
    private final transient List<Seal.MessageHeader> listHttpHeader = new ArrayList<Seal.MessageHeader>();

    public NetworkTable(TabbedPaneNetworkTab tabbedPaneNetworkTab) {
        super(0, 4);
        this.setName(NETWORK_TABLE);
        this.setComponentPopupMenu(new JPopupMenuTable(this));
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(2);
        this.setRowHeight(20);
        this.getTableHeader().setReorderingAllowed(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                NetworkTable.this.requestFocusInWindow();
                if (SwingUtilities.isRightMouseButton(e)) {
                    Point point = e.getPoint();
                    int rowNumber = NetworkTable.this.rowAtPoint(point);
                    int colNumber = NetworkTable.this.columnAtPoint(point);
                    DefaultListSelectionModel modelRow = (DefaultListSelectionModel)NetworkTable.this.getSelectionModel();
                    DefaultListSelectionModel modelColumn = (DefaultListSelectionModel)NetworkTable.this.getColumnModel().getSelectionModel();
                    NetworkTable.this.setRowSelectionInterval(rowNumber, rowNumber);
                    modelRow.moveLeadSelectionIndex(rowNumber);
                    modelColumn.moveLeadSelectionIndex(colNumber);
                }
            }
        });
        this.setModel(new DefaultTableModel(){
            private final String[] columns = new String[]{I18nUtil.valueByKey("NETWORK_TAB_URL_COLUMN"), String.format("%s (KB)", I18nUtil.valueByKey("NETWORK_TAB_SIZE_COLUMN")), I18nUtil.valueByKey("SQLENGINE_STRATEGY"), I18nUtil.valueByKey("SQLENGINE_METADATA")};

            @Override
            public int getColumnCount() {
                return this.columns.length;
            }

            @Override
            public String getColumnName(int index) {
                return this.columns[index];
            }
        });
        this.getColumnModel().getColumn(0).setCellRenderer(new TooltipCellRenderer());
        CenterRenderer centerHorizontalAlignment = new CenterRenderer();
        this.getColumnModel().getColumn(1).setCellRenderer(centerHorizontalAlignment);
        this.getColumnModel().getColumn(2).setCellRenderer(centerHorizontalAlignment);
        this.getColumnModel().getColumn(3).setCellRenderer(new CenterRendererWithIcon());
        this.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), null);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(9, 64), null);
        HashSet<AWTKeyStroke> forward = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
        forward.add(KeyStroke.getKeyStroke("TAB"));
        this.setFocusTraversalKeys(0, forward);
        HashSet<AWTKeyStroke> backward = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(1));
        backward.add(KeyStroke.getKeyStroke("shift TAB"));
        this.setFocusTraversalKeys(1, backward);
        this.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.getColumnModel().getColumn(1).setPreferredWidth(20);
        this.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.getColumnModel().getColumn(3).setPreferredWidth(70);
        this.getSelectionModel().addListSelectionListener(event -> {
            if (!event.getValueIsAdjusting() && this.getSelectedRow() > -1) {
                Seal.MessageHeader httpHeader = this.listHttpHeader.get(this.getSelectedRow());
                tabbedPaneNetworkTab.changeTextNetwork(httpHeader);
            }
        });
        tabbedPaneNetworkTab.getCheckBoxDecode().addActionListener(e -> {
            MediatorHelper.model().getMediatorUtils().preferencesUtil().withIsUrlDecodeNetworkTab(tabbedPaneNetworkTab.getCheckBoxDecode().isSelected()).persist();
            if (this.getSelectedRow() > -1) {
                Seal.MessageHeader httpHeader = this.listHttpHeader.get(this.getSelectedRow());
                tabbedPaneNetworkTab.changeTextNetwork(httpHeader);
            }
        });
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public List<Seal.MessageHeader> getListHttpHeader() {
        return this.listHttpHeader;
    }

    public void addHeader(Seal.MessageHeader header) {
        this.listHttpHeader.add(header);
    }
}

