/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.dialog;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.popupmenu.JPopupMenuText;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogAbout
extends JDialog {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private JButton buttonClose = null;

    public DialogAbout() {
        super((Window)MediatorHelper.frame(), I18nUtil.valueByKey("ABOUT_WINDOW_TITLE") + " jSQL Injection", Dialog.ModalityType.MODELESS);
        I18nViewUtil.addComponentForKey("ABOUT_WINDOW_TITLE", this);
        this.setDefaultCloseOperation(2);
        this.setIconImages(UiUtil.getIcons());
        ActionListener escapeListener = actionEvent -> this.dispose();
        this.getRootPane().registerKeyboardAction(escapeListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.setLayout(new BorderLayout());
        Container dialogPane = this.getContentPane();
        JPanel lastLine = this.initLastLine(escapeListener);
        JLabel labelIcon = new JLabel(UiUtil.APP_MIDDLE.getIcon());
        labelIcon.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        dialogPane.add((Component)labelIcon, "West");
        dialogPane.add((Component)lastLine, "South");
        JEditorPane text = this.initEditorPane();
        dialogPane.add((Component)new JScrollPane(text), "Center");
        this.initDialog();
    }

    private JPanel initLastLine(ActionListener escapeListener) {
        JButton buttonWebpage = new JButton(I18nUtil.valueByKey("ABOUT_WEBPAGE"));
        I18nViewUtil.addComponentForKey("ABOUT_WEBPAGE", buttonWebpage);
        buttonWebpage.addActionListener(ev -> {
            try {
                Desktop.getDesktop().browse(new URI(MediatorHelper.model().getMediatorUtils().propertiesUtil().getProperty("github.url")));
            }
            catch (IOException | UnsupportedOperationException | URISyntaxException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Browsing to Url failed", (Throwable)e);
            }
        });
        this.buttonClose = new JButton(I18nUtil.valueByKey("ABOUT_CLOSE"));
        I18nViewUtil.addComponentForKey("ABOUT_CLOSE", this.buttonClose);
        this.buttonClose.addActionListener(escapeListener);
        JPanel lastLine = new JPanel();
        lastLine.setLayout(new BoxLayout(lastLine, 2));
        lastLine.setBorder(UiUtil.BORDER_5PX);
        lastLine.add(buttonWebpage);
        lastLine.add(Box.createGlue());
        lastLine.add(this.buttonClose);
        return lastLine;
    }

    private JEditorPane initEditorPane() {
        final JEditorPane editorPane = new JEditorPane();
        try (InputStream inputStream = DialogAbout.class.getClassLoader().getResourceAsStream("swing/about.htm");
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            editorPane.setContentType("text/html");
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            editorPane.setText(result.toString().replace("%JSQLVERSION%", MediatorHelper.model().getPropertiesUtil().getVersionJsql()));
        }
        catch (IOException | NoClassDefFoundError e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, e);
        }
        editorPane.addMouseListener(new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                editorPane.requestFocusInWindow();
            }
        });
        editorPane.addFocusListener(new FocusAdapter(this){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                editorPane.getCaret().setVisible(true);
                editorPane.getCaret().setSelectionVisible(true);
            }
        });
        editorPane.setDragEnabled(true);
        editorPane.setEditable(false);
        editorPane.getCaret().setBlinkRate(0);
        editorPane.setCaretPosition(0);
        editorPane.setComponentPopupMenu(new JPopupMenuText(editorPane));
        editorPane.addHyperlinkListener(linkEvent -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(linkEvent.getEventType())) {
                try {
                    Desktop.getDesktop().browse(linkEvent.getURL().toURI());
                }
                catch (IOException | UnsupportedOperationException | URISyntaxException e) {
                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Browsing to Url failed", (Throwable)e);
                }
            }
        });
        return editorPane;
    }

    public final void initDialog() {
        this.setSize(560, 400);
        this.setLocationRelativeTo(MediatorHelper.frame());
        this.buttonClose.requestFocusInWindow();
        this.getRootPane().setDefaultButton(this.buttonClose);
    }

    public void requestButtonFocus() {
        this.buttonClose.requestFocusInWindow();
    }
}

