/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.util.LogLevelUtil;
import com.jsql.util.PreferencesUtil;
import com.jsql.util.bruter.Base58;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;
import org.apache.commons.codec.binary.Base16;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class StringUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final CharEncoder DECIMAL_HTML_ENCODER = new CharEncoder("&#", ";", 10);
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String INFORMATION_SCHEMA = "information_schema";
    public static final String APP_NAME = "jSQL Injection";

    private StringUtil() {
    }

    public static String toHtmlDecimal(String text) {
        return StringUtil.encode(text);
    }

    private static String encode(String text) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) > '\u0080') {
                DECIMAL_HTML_ENCODER.encode(text.charAt(i), buff);
                continue;
            }
            buff.append(text.charAt(i));
        }
        return buff.toString();
    }

    public static String hexstr(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String detectUtf8(String text) {
        if (text == null) {
            return "";
        }
        String result = text;
        if (StringUtil.containsNonStandardScripts(text)) {
            result = new String(text.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
        }
        return result;
    }

    public static boolean containsNonStandardScripts(String text) {
        if (text == null) {
            return false;
        }
        return text.codePoints().anyMatch(codePoint -> {
            Character.UnicodeScript script = Character.UnicodeScript.of(codePoint);
            return script != Character.UnicodeScript.LATIN && script != Character.UnicodeScript.COMMON;
        });
    }

    public static String base32Encode(String s) {
        Base32 base322 = new Base32();
        return base322.encodeToString(StringUtil.getBytesUtf8(s));
    }

    public static String base32Decode(String s) {
        Base32 base322 = new Base32();
        return StringUtil.newStringUtf8(base322.decode(s));
    }

    public static String base58Encode(String s) {
        return Base58.encode(StringUtil.getBytesUtf8(s));
    }

    public static String base58Decode(String s) {
        return StringUtil.newStringUtf8(Base58.decode(s));
    }

    public static String base16Encode(String s) {
        Base16 base162 = new Base16();
        return base162.encodeToString(StringUtil.getBytesUtf8(s));
    }

    public static String base16Decode(String s) {
        Base16 base162 = new Base16();
        return StringUtil.newStringUtf8(base162.decode(s));
    }

    public static String base64Decode(String s) {
        return StringUtil.newStringUtf8(Base64.getDecoder().decode(s));
    }

    public static String base64Encode(String s) {
        return Base64.getEncoder().encodeToString(StringUtil.getBytesUtf8(s));
    }

    public static String toHex(String text) {
        return StringUtil.encodeHexString(text.getBytes(StandardCharsets.UTF_8));
    }

    public static String fromHex(String text) {
        byte[] hex = StringUtil.decodeHexString(text);
        return new String(hex, StandardCharsets.UTF_8);
    }

    public static String toHexZip(String text) throws IOException {
        byte[] zip = StringUtil.compress(text);
        return StringUtil.encodeHexString(zip);
    }

    public static String fromHexZip(String text) throws IOException {
        return new String(StringUtil.decompress(StringUtil.decodeHexString(text)), StandardCharsets.UTF_8);
    }

    public static String toBase64Zip(String text) throws IOException {
        return new String(Base64.getEncoder().encode(StringUtil.compress(text)));
    }

    public static String fromBase64Zip(String text) throws IOException {
        byte[] decompressedBArray = StringUtil.decompress(Base64.getDecoder().decode(text));
        return new String(decompressedBArray, StandardCharsets.UTF_8);
    }

    public static String toHtml(String text) {
        return StringEscapeUtils.escapeHtml4(text);
    }

    public static String fromHtml(String text) {
        return StringEscapeUtils.unescapeHtml4(text);
    }

    public static String toUrl(String text) {
        return URLEncoder.encode(text, StandardCharsets.UTF_8);
    }

    public static String fromUrl(String text) {
        return URLDecoder.decode(text, StandardCharsets.UTF_8);
    }

    public static String cleanSql(String query) {
        return StringUtil.removeSqlComment(query).replaceAll("(?s)([^\\s\\w])(\\s+)", "$1").replaceAll("(?s)(\\s+)([^\\s\\w])", "$2").replaceAll("(?s)\\s+", " ").trim();
    }

    public static String removeSqlComment(String query) {
        return query.replaceAll("(?s)(?!/\\*\\*/|/\\*!.*\\*/)/\\*.*?\\*/", "");
    }

    public static String formatReport(Color color, String text) {
        return String.format("<span style=color:rgb(%s,%s,%s)>%s</span>", color.getRed(), color.getGreen(), color.getBlue(), text);
    }

    private static byte[] compress(String text) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (DeflaterOutputStream dos = new DeflaterOutputStream(os);){
            dos.write(text.getBytes());
        }
        return os.toByteArray();
    }

    private static byte[] decompress(byte[] compressedTxt) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (InflaterOutputStream ios = new InflaterOutputStream(os);){
            ((OutputStream)ios).write(compressedTxt);
        }
        return os.toByteArray();
    }

    private static byte hexToByte(String hexString) {
        int firstDigit = StringUtil.toDigit(hexString.charAt(0));
        int secondDigit = StringUtil.toDigit(hexString.charAt(1));
        return (byte)((firstDigit << 4) + secondDigit);
    }

    private static int toDigit(char hexChar) {
        int digit = Character.digit(hexChar, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }

    private static String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    private static String encodeHexString(byte[] byteArray) {
        StringBuilder hexStringBuffer = new StringBuilder();
        for (byte b : byteArray) {
            hexStringBuffer.append(StringUtil.byteToHex(b));
        }
        return hexStringBuffer.toString();
    }

    private static byte[] decodeHexString(String hexString) {
        if (hexString.length() % 2 == 1) {
            throw new IllegalArgumentException("Invalid hexadecimal String supplied.");
        }
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length(); i += 2) {
            bytes[i / 2] = StringUtil.hexToByte(hexString.substring(i, i + 2));
        }
        return bytes;
    }

    private static byte[] getBytesUtf8(String string) {
        return string == null ? null : string.getBytes(StandardCharsets.UTF_8);
    }

    private static String newStringUtf8(byte[] bytes) {
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] xor(byte[] plaintext, int key) {
        byte[] ciphertext = new byte[plaintext.length];
        for (int i = 0; i < plaintext.length; ++i) {
            ciphertext[i] = (byte)(Byte.toUnsignedInt(plaintext[i]) ^ key >>> 8 * (i % 4));
        }
        return ciphertext;
    }

    public static List<String> toHexChunks(byte[] fileData) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : fileData) {
            hexString.append(String.format("%02X", b));
        }
        int chunkSize = 900;
        ArrayList<String> chunks = new ArrayList<String>();
        for (int i = 0; i < hexString.length(); i += chunkSize) {
            int endIndex = Math.min(i + chunkSize, hexString.length());
            chunks.add(hexString.substring(i, endIndex));
        }
        return chunks;
    }

    public static String getFile(String path) {
        StringBuilder content = new StringBuilder();
        try (InputStream inputStream = PreferencesUtil.class.getClassLoader().getResourceAsStream(path);
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return content.toString();
    }

    public static byte[] uncloak(byte[] fileData) {
        byte[] fileDataUncloaked = StringUtil.xor(fileData, 353837730);
        ArrayUtils.reverse(fileDataUncloaked);
        return fileDataUncloaked;
    }

    private record CharEncoder(String prefix, String suffix, int radix) {
        private void encode(char c, StringBuilder buff) {
            buff.append(this.prefix).append(Integer.toString(c, this.radix)).append(this.suffix);
        }
    }
}

