/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBit;
import com.jsql.model.injection.strategy.blind.AbstractInjectionMonobit;
import com.jsql.model.injection.strategy.blind.callable.BinRanges;
import com.jsql.model.injection.strategy.blind.callable.CallableBlindBin;
import com.jsql.model.injection.strategy.blind.patch.Diff;
import com.jsql.model.injection.strategy.blind.patch.DiffMatchPatch;
import com.jsql.util.LogLevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionBlindBin
extends AbstractInjectionMonobit<CallableBlindBin> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final int LOW = 0;
    private static final int HIGH = 127;
    private String sourceReferencePage;
    private List<Diff> falseDiffs = new ArrayList<Diff>();
    private List<Diff> trueDiffs = new ArrayList<Diff>();

    public InjectionBlindBin(InjectionModel injectionModel, AbstractInjectionBit.BlindOperator blindOperator) {
        super(injectionModel, blindOperator);
        List<String> falsys = this.injectionModel.getMediatorEngine().getEngine().instance().getFalsyBin();
        if (falsys.isEmpty() || this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.sourceReferencePage = this.callUrl("", "bin#ref:" + blindOperator.toString().toLowerCase());
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().threadUtil().getExecutor("CallableGetBlindBinTagFalse");
        ArrayList<CallableBlindBin> callablesFalsys = new ArrayList<CallableBlindBin>();
        for (String falsy : falsys) {
            callablesFalsys.add(new CallableBlindBin(falsy, injectionModel, this, blindOperator, new BinRanges(-1, -1, -1), "bin#falsy"));
        }
        try {
            List futuresFalsys = taskExecutor.invokeAll(callablesFalsys);
            this.injectionModel.getMediatorUtils().threadUtil().shutdown(taskExecutor);
            for (Future futureFalsy : futuresFalsys) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (this.falseDiffs.isEmpty()) {
                    this.falseDiffs = ((CallableBlindBin)futureFalsy.get()).getDiffsWithReference();
                    continue;
                }
                this.falseDiffs.retainAll(((CallableBlindBin)futureFalsy.get()).getDiffsWithReference());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.cleanTrueDiffs(injectionModel, blindOperator);
    }

    private void cleanTrueDiffs(InjectionModel injectionModel, AbstractInjectionBit.BlindOperator blindOperator) {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().threadUtil().getExecutor("CallableGetBlindBinTagTrue");
        ArrayList<CallableBlindBin> callablesTruthys = new ArrayList<CallableBlindBin>();
        List<String> truthys = this.injectionModel.getMediatorEngine().getEngine().instance().getTruthyBin();
        for (String truthy : truthys) {
            callablesTruthys.add(new CallableBlindBin(truthy, injectionModel, this, blindOperator, new BinRanges(-1, -1, -1), "bin#truthy"));
        }
        try {
            List futuresTruthys = taskExecutor.invokeAll(callablesTruthys);
            this.injectionModel.getMediatorUtils().threadUtil().shutdown(taskExecutor);
            for (Future futureTruthy : futuresTruthys) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (this.trueDiffs.isEmpty()) {
                    this.trueDiffs = ((CallableBlindBin)futureTruthy.get()).getDiffsWithReference();
                } else {
                    this.trueDiffs.retainAll(((CallableBlindBin)futureTruthy.get()).getDiffsWithReference());
                }
                this.falseDiffs.removeAll(((CallableBlindBin)futureTruthy.get()).getDiffsWithReference());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CallableBlindBin getCallableBitTest(String sqlQuery, int indexChar, int bit) {
        return null;
    }

    @Override
    public boolean isInjectable() throws StoppedByUserSlidingException {
        if (this.injectionModel.isStoppedByUser()) {
            throw new StoppedByUserSlidingException();
        }
        CallableBlindBin blindTest = new CallableBlindBin(this.injectionModel.getMediatorEngine().getEngine().instance().sqlBlindConfirm(), this.injectionModel, this, this.blindOperator, new BinRanges(-1, -1, -1), "bin#confirm");
        try {
            blindTest.call();
        }
        catch (Exception e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return blindTest.isTrue() && this.trueDiffs.stream().anyMatch(diff -> !DiffMatchPatch.Operation.EQUAL.equals((Object)diff.getOperation())) || this.falseDiffs.stream().anyMatch(diff -> !DiffMatchPatch.Operation.EQUAL.equals((Object)diff.getOperation()));
    }

    @Override
    public void initNextChar(String sqlQuery, List<char[]> bytes, AtomicInteger indexChar, CompletionService<CallableBlindBin> taskCompletionService, AtomicInteger countTasksSubmitted, AtomicInteger countBadAsciiCode, CallableBlindBin currentCallable) {
        int high;
        int mid;
        int low;
        if (currentCallable != null) {
            low = currentCallable.getBinRanges().low();
            mid = currentCallable.getBinRanges().mid();
            high = currentCallable.getBinRanges().high();
            if (low >= high) {
                if (this.isCorruptOrElseNextChar(bytes, indexChar, countBadAsciiCode, currentCallable, low)) {
                    return;
                }
                low = 0;
                high = 127;
            } else if (currentCallable.isTrue()) {
                low = mid + 1;
            } else {
                high = mid - 1;
            }
        } else {
            low = 0;
            high = 127;
            bytes.add(AbstractInjectionBit.getBitsUnset());
            indexChar.incrementAndGet();
        }
        mid = low + (high - low) / 2;
        taskCompletionService.submit(new CallableBlindBin(sqlQuery, indexChar.get(), this.injectionModel, this, this.blindOperator, new BinRanges(low, mid, high), String.format("bin#%s~%s<%s<%s", indexChar, low, mid, high)));
        countTasksSubmitted.addAndGet(1);
    }

    private boolean isCorruptOrElseNextChar(List<char[]> bytes, AtomicInteger indexChar, AtomicInteger countBadAsciiCode, CallableBlindBin currentCallable, int low) {
        int currentLow = low;
        if (currentLow == 0 || currentLow == 127) {
            countBadAsciiCode.incrementAndGet();
        } else {
            currentLow = currentCallable.isTrue() ? currentLow : currentLow - 1;
        }
        char[] asciiCodeMask = bytes.get(currentCallable.getCurrentIndex() - 1);
        this.setAsciiCodeMask(asciiCodeMask, currentLow);
        try {
            this.isCharCompleteWithCorruptCheck(bytes, countBadAsciiCode, currentCallable);
        }
        catch (InjectionFailureException e) {
            return true;
        }
        bytes.add(AbstractInjectionBit.getBitsUnset());
        indexChar.incrementAndGet();
        return false;
    }

    private void setAsciiCodeMask(char[] asciiCodeMask, int value) {
        String binary = StringUtils.leftPad(Integer.toBinaryString((char)value), 8, "0");
        for (int i = 0; i <= 7; ++i) {
            asciiCodeMask[i] = binary.charAt(i);
        }
    }

    @Override
    public char[] initMaskAsciiChar(List<char[]> bytes, CallableBlindBin currentCallable) {
        return bytes.get(currentCallable.getCurrentIndex() - 1);
    }

    @Override
    public String getInfoMessage() {
        return "- Strategy Blind bin: query True when Diffs are matching " + String.valueOf(this.falseDiffs) + "\n\n";
    }

    public String getSourceReferencePage() {
        return this.sourceReferencePage;
    }

    public List<Diff> getFalseDiffs() {
        return this.falseDiffs;
    }

    public List<Diff> getTrueDiffs() {
        return this.trueDiffs;
    }
}

