/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible;

import com.jsql.model.InjectionModel;
import com.jsql.util.ConnectionUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.subscriber.Seal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CallableHttpHead
implements Callable<CallableHttpHead> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final String urlAdminPage;
    private String responseCodeHttp = "";
    private final InjectionModel injectionModel;
    private final String metadataInjectionProcess;

    public CallableHttpHead(String urlAdminPage, InjectionModel injectionModel, String metadataInjectionProcess) {
        this.urlAdminPage = urlAdminPage;
        this.injectionModel = injectionModel;
        this.metadataInjectionProcess = metadataInjectionProcess;
    }

    @Override
    public CallableHttpHead call() {
        if (this.injectionModel.getResourceAccess().isSearchAdminStopped()) {
            return this;
        }
        try {
            HttpRequest.Builder builderHttpRequest = HttpRequest.newBuilder().uri(URI.create(this.urlAdminPage)).method("HEAD", HttpRequest.BodyPublishers.noBody()).timeout(Duration.ofSeconds(4L));
            Stream.of(this.injectionModel.getMediatorUtils().parameterUtil().getHeaderFromEntries().split("\\\\r\\\\n")).map(e -> {
                if (e.split(":").length == 2) {
                    return new AbstractMap.SimpleEntry<String, String>(e.split(":")[0], e.split(":")[1]);
                }
                return null;
            }).filter(Objects::nonNull).forEach(e -> builderHttpRequest.header((String)e.getKey(), (String)e.getValue()));
            HttpRequest httpRequest = builderHttpRequest.build();
            HttpClient httpClient = this.injectionModel.getMediatorUtils().connectionUtil().getHttpClient().connectTimeout(Duration.ofSeconds(4L)).build();
            HttpResponse<Void> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.discarding());
            this.responseCodeHttp = String.valueOf(response.statusCode());
            this.injectionModel.sendToViews(new Seal.MessageHeader(this.urlAdminPage, null, ConnectionUtil.getHeadersMap(httpRequest.headers()), ConnectionUtil.getHeadersMap(response), null, null, null, this.metadataInjectionProcess, null));
        }
        catch (InterruptedException e2) {
            LOGGER.log(LogLevelUtil.IGNORE, e2, (Throwable)e2);
            Thread.currentThread().interrupt();
        }
        catch (Exception e3) {
            String eMessageImplicit = String.format("Problem connecting to %s (implicit reason): %s", this.urlAdminPage, InjectionModel.getImplicitReason(e3));
            String eMessage = Optional.ofNullable(e3.getMessage()).orElse(eMessageImplicit);
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, eMessage);
        }
        return this;
    }

    public boolean isHttpResponseOk() {
        return this.responseCodeHttp.matches("[23]\\d\\d");
    }

    public String getUrl() {
        return this.urlAdminPage;
    }
}

