/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class AsyncSemaphore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncSemaphore.class);
    private final Queue<CompletableFuture<Permit>> queue = new ArrayDeque<CompletableFuture<Permit>>();
    private final Permit singletonPermit = new Permit();
    private final String name;
    private volatile int permits;

    AsyncSemaphore(int permits, String name) {
        this.permits = permits;
        this.name = name;
        log.debug("Using Java 11+ implementation for {}", (Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletionStage<Permit> acquire(Duration timeout, int id, Executor executor) {
        Queue<CompletableFuture<Permit>> queue = this.queue;
        synchronized (queue) {
            if (this.permits > 0) {
                --this.permits;
                log.trace("{} permit acquired id={}, available={}", this.name, id, this.permits);
                return CompletableFuture.completedFuture(this.singletonPermit);
            }
            CompletableFuture<Permit> f = new CompletableFuture<Permit>();
            f.orTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS).whenCompleteAsync((result, ex) -> {
                Queue<CompletableFuture<Permit>> queue = this.queue;
                synchronized (queue) {
                    if (ex != null) {
                        log.trace("{} permit timed out id={}, available={}", this.name, id, this.permits);
                    }
                    this.queue.remove(f);
                }
            }, executor);
            log.trace("{} permit queued id={}, available={}", this.name, id, this.permits);
            this.queue.add(f);
            return f;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    final class Permit {
        Permit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(int id, Executor executor) {
            Queue<CompletableFuture<Permit>> queue = AsyncSemaphore.this.queue;
            synchronized (queue) {
                CompletableFuture<Permit> next = AsyncSemaphore.this.queue.poll();
                if (next == null) {
                    ++AsyncSemaphore.this.permits;
                    log.trace("{} permit released id={}, available={}", AsyncSemaphore.this.name, id, AsyncSemaphore.this.permits);
                } else {
                    log.trace("{} permit released id={}, available={}, immediate next", AsyncSemaphore.this.name, id, AsyncSemaphore.this.permits);
                    next.completeAsync(() -> this, executor);
                }
            }
        }
    }
}

